/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.engine.discovery;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.jqwik.engine.descriptor.ContainerClassDescriptor;
import net.jqwik.engine.descriptor.DiscoverySupport;
import net.jqwik.engine.discovery.ElementResolver;
import net.jqwik.engine.discovery.predicates.IsContainerAGroup;
import net.jqwik.engine.discovery.predicates.IsDiscoverableTestMethod;
import net.jqwik.engine.support.JqwikExceptionSupport;
import org.junit.platform.commons.support.HierarchyTraversalMode;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.engine.SelectorResolutionResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.UniqueId;

class HierarchicalJavaResolver {
    private static final Logger LOG = Logger.getLogger(HierarchicalJavaResolver.class.getName());
    private static final IsContainerAGroup isContainerAGroup = new IsContainerAGroup();
    private static final IsDiscoverableTestMethod isDiscoverableTestMethod = new IsDiscoverableTestMethod();
    private final TestDescriptor engineDescriptor;
    private final Set<ElementResolver> resolvers;

    HierarchicalJavaResolver(TestDescriptor engineDescriptor, Set<ElementResolver> resolvers) {
        this.engineDescriptor = engineDescriptor;
        this.resolvers = resolvers;
    }

    SelectorResolutionResult resolveClass(Class<?> testClass) {
        return this.resolveSafely(() -> {
            Set<TestDescriptor> resolvedDescriptors = this.resolveContainerWithParents(testClass);
            resolvedDescriptors.forEach(this::resolveChildren);
            this.warnWhenJUnitAnnotationsArePresent(resolvedDescriptors);
            if (resolvedDescriptors.isEmpty()) {
                return SelectorResolutionResult.unresolved();
            }
            return SelectorResolutionResult.resolved();
        });
    }

    private void warnWhenJUnitAnnotationsArePresent(Set<TestDescriptor> resolvedDescriptors) {
        resolvedDescriptors.stream().filter(d -> !d.getChildren().isEmpty()).filter(d -> d instanceof ContainerClassDescriptor).map(d -> (ContainerClassDescriptor)d).forEach(d -> DiscoverySupport.warnWhenJunitAnnotationsArePresent(d.getContainerClass()));
    }

    SelectorResolutionResult resolveMethod(Class<?> testClass, Method testMethod) {
        return this.resolveSafely(() -> {
            Set<TestDescriptor> potentialParents = this.resolveContainerWithParents(testClass);
            Set<TestDescriptor> resolvedDescriptors = this.resolveForAllParents(testMethod, potentialParents);
            if (resolvedDescriptors.isEmpty()) {
                return SelectorResolutionResult.unresolved();
            }
            return SelectorResolutionResult.resolved();
        });
    }

    SelectorResolutionResult resolveUniqueId(UniqueId uniqueId) {
        return this.resolveSafely(() -> {
            if (uniqueId.getEngineId().isPresent() && !((String)uniqueId.getEngineId().get()).equals("jqwik")) {
                return SelectorResolutionResult.unresolved();
            }
            ArrayList<UniqueId.Segment> segments = new ArrayList<UniqueId.Segment>(uniqueId.getSegments());
            segments.remove(0);
            if (!this.resolveUniqueId(this.engineDescriptor, segments)) {
                LOG.warning(() -> String.format("Received request to resolve unique id '%s' as test or test container but could not fulfill it", uniqueId));
                return SelectorResolutionResult.unresolved();
            }
            return SelectorResolutionResult.resolved();
        });
    }

    private SelectorResolutionResult resolveSafely(Callable<SelectorResolutionResult> callable) {
        try {
            return callable.call();
        }
        catch (Throwable t) {
            JqwikExceptionSupport.rethrowIfBlacklisted(t);
            return SelectorResolutionResult.failed((Throwable)t);
        }
    }

    private Set<TestDescriptor> resolveContainerWithParents(Class<?> testClass) {
        Set<TestDescriptor> potentialParents = isContainerAGroup.test(testClass) ? this.resolveContainerWithParents(testClass.getDeclaringClass()) : Collections.singleton(this.engineDescriptor);
        return this.resolveForAllParents(testClass, potentialParents);
    }

    private boolean resolveUniqueId(TestDescriptor parent, List<UniqueId.Segment> remainingSegments) {
        if (remainingSegments.isEmpty()) {
            this.resolveChildren(parent);
            return true;
        }
        UniqueId.Segment head = remainingSegments.remove(0);
        for (ElementResolver resolver : this.resolvers) {
            Optional<TestDescriptor> resolvedDescriptor = resolver.resolveUniqueId(head, parent);
            if (!resolvedDescriptor.isPresent()) continue;
            Optional<TestDescriptor> foundTestDescriptor = this.findTestDescriptorByUniqueId(resolvedDescriptor.get().getUniqueId());
            TestDescriptor descriptor = foundTestDescriptor.orElseGet(() -> {
                TestDescriptor newDescriptor = (TestDescriptor)resolvedDescriptor.get();
                parent.addChild(newDescriptor);
                return newDescriptor;
            });
            return this.resolveUniqueId(descriptor, remainingSegments);
        }
        return false;
    }

    private Set<TestDescriptor> resolveContainerWithChildren(Class<?> containerClass, Set<TestDescriptor> potentialParents) {
        Set<TestDescriptor> resolvedDescriptors = this.resolveForAllParents(containerClass, potentialParents);
        resolvedDescriptors.forEach(this::resolveChildren);
        return resolvedDescriptors;
    }

    private Set<TestDescriptor> resolveForAllParents(AnnotatedElement element, Set<TestDescriptor> potentialParents) {
        HashSet<TestDescriptor> resolvedDescriptors = new HashSet<TestDescriptor>();
        potentialParents.forEach(parent -> resolvedDescriptors.addAll(this.resolve(element, (TestDescriptor)parent)));
        return resolvedDescriptors;
    }

    private void resolveChildren(TestDescriptor descriptor) {
        if (descriptor instanceof ContainerClassDescriptor) {
            ContainerClassDescriptor containerClassDescriptor = (ContainerClassDescriptor)descriptor;
            Class<?> containerClass = containerClassDescriptor.getContainerClass();
            this.resolveContainedMethods(descriptor, containerClass);
            this.resolveContainedGroups(containerClassDescriptor, containerClass);
        }
    }

    private void resolveContainedGroups(ContainerClassDescriptor containerClassDescriptor, Class<?> containerClass) {
        IsContainerAGroup isGroup = new IsContainerAGroup();
        List containedContainersCandidates = ReflectionSupport.findNestedClasses(containerClass, (Predicate)isGroup);
        containedContainersCandidates.forEach(nestedClass -> this.resolveContainerWithChildren((Class<?>)nestedClass, Collections.singleton(containerClassDescriptor)));
    }

    private void resolveContainedMethods(TestDescriptor containerDescriptor, Class<?> testClass) {
        List testMethodCandidates = ReflectionSupport.findMethods(testClass, (Predicate)isDiscoverableTestMethod, (HierarchyTraversalMode)HierarchyTraversalMode.TOP_DOWN);
        testMethodCandidates.forEach(method -> this.resolve((AnnotatedElement)method, containerDescriptor));
    }

    private Set<TestDescriptor> resolve(AnnotatedElement element, TestDescriptor parent) {
        return this.resolvers.stream().map(resolver -> this.tryToResolveWithResolver(element, parent, (ElementResolver)resolver)).filter(testDescriptors -> !testDescriptors.isEmpty()).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<TestDescriptor> tryToResolveWithResolver(AnnotatedElement element, TestDescriptor parent, ElementResolver resolver) {
        Set<TestDescriptor> resolvedDescriptors = resolver.resolveElement(element, parent);
        LinkedHashSet<TestDescriptor> result = new LinkedHashSet<TestDescriptor>();
        resolvedDescriptors.forEach(testDescriptor -> {
            Optional<TestDescriptor> existingTestDescriptor = this.findTestDescriptorByUniqueId(testDescriptor.getUniqueId());
            if (existingTestDescriptor.isPresent()) {
                result.add(existingTestDescriptor.get());
            } else {
                parent.addChild(testDescriptor);
                result.add((TestDescriptor)testDescriptor);
            }
        });
        return result;
    }

    private Optional<TestDescriptor> findTestDescriptorByUniqueId(UniqueId uniqueId) {
        return this.engineDescriptor.findByUniqueId(uniqueId);
    }
}

