/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api.lifecycle;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Optional;
import net.jqwik.api.JqwikException;
import net.jqwik.api.lifecycle.AddLifecycleHook;
import net.jqwik.api.lifecycle.AroundPropertyHook;
import net.jqwik.api.lifecycle.LifecycleContext;
import net.jqwik.api.lifecycle.Lifespan;
import net.jqwik.api.lifecycle.ParameterResolutionContext;
import net.jqwik.api.lifecycle.PropertyExecutionResult;
import net.jqwik.api.lifecycle.PropertyExecutor;
import net.jqwik.api.lifecycle.PropertyLifecycleContext;
import net.jqwik.api.lifecycle.ResolveParameterHook;
import net.jqwik.api.lifecycle.Store;
import org.apiguardian.api.API;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD})
@Retention(value=RetentionPolicy.RUNTIME)
@AddLifecycleHook(value=PerPropertyHook.class)
@API(status=API.Status.EXPERIMENTAL, since="1.2.4")
public @interface PerProperty {
    public Class<? extends Lifecycle> value();

    public static class PerPropertyHook
    implements AroundPropertyHook,
    ResolveParameterHook {
        private Lifecycle lifecycle(LifecycleContext context) {
            return Store.getOrCreate("lifecycle", Lifespan.PROPERTY, () -> this.createLifecycleInstance(context)).get();
        }

        private Lifecycle createLifecycleInstance(LifecycleContext context) {
            Optional<PerProperty> perProperty = context.findAnnotation(PerProperty.class);
            Class lifecycleClass = perProperty.map(PerProperty::value).orElseThrow(() -> {
                String message = "@PerProperty annotation MUST have a value() attribute";
                return new JqwikException(message);
            });
            return (Lifecycle)context.newInstance(lifecycleClass);
        }

        @Override
        public PropertyExecutionResult aroundProperty(PropertyLifecycleContext context, PropertyExecutor property) {
            Lifecycle lifecycle = this.lifecycle(context);
            this.runBeforeExecutionLifecycles(context, lifecycle);
            PropertyExecutionResult executionResult = property.execute();
            return this.runAfterExecutionLifecycles(lifecycle, executionResult);
        }

        private void runBeforeExecutionLifecycles(PropertyLifecycleContext context, Lifecycle lifecycle) {
            lifecycle.before(context);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PropertyExecutionResult runAfterExecutionLifecycles(Lifecycle lifecycle, PropertyExecutionResult executionResult) {
            try {
                if (executionResult.status() == PropertyExecutionResult.Status.SUCCESSFUL) {
                    try {
                        lifecycle.onSuccess();
                    }
                    catch (Throwable throwable) {
                        PropertyExecutionResult propertyExecutionResult = executionResult.mapToFailed(throwable);
                        lifecycle.after(executionResult);
                        return propertyExecutionResult;
                    }
                } else if (executionResult.status() == PropertyExecutionResult.Status.FAILED) {
                    PropertyExecutionResult propertyExecutionResult = lifecycle.onFailure(executionResult);
                    return propertyExecutionResult;
                }
                PropertyExecutionResult propertyExecutionResult = executionResult;
                return propertyExecutionResult;
            }
            finally {
                lifecycle.after(executionResult);
            }
        }

        @Override
        public int aroundPropertyProximity() {
            return 10;
        }

        @Override
        public Optional<ResolveParameterHook.ParameterSupplier> resolve(ParameterResolutionContext parameterContext, LifecycleContext lifecycleContext) {
            return this.lifecycle(lifecycleContext).resolve(parameterContext);
        }
    }

    public static interface Lifecycle {
        default public Optional<ResolveParameterHook.ParameterSupplier> resolve(ParameterResolutionContext parameterContext) {
            return Optional.empty();
        }

        default public void before(PropertyLifecycleContext context) {
        }

        default public void after(PropertyExecutionResult propertyExecutionResult) {
        }

        default public void onSuccess() {
        }

        default public PropertyExecutionResult onFailure(PropertyExecutionResult propertyExecutionResult) {
            return propertyExecutionResult;
        }
    }
}

