/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.FacadeLoader;
import net.jqwik.api.Falsifier;
import net.jqwik.api.ShrinkingDistance;
import net.jqwik.api.ShrinkingSequence;
import net.jqwik.api.lifecycle.TryExecutionResult;
import org.apiguardian.api.API;

@API(status=API.Status.STABLE, since="1.0")
public interface Shrinkable<T>
extends Comparable<Shrinkable<T>> {
    public static <T> Shrinkable<T> unshrinkable(T value) {
        return Shrinkable.unshrinkable(value, ShrinkingDistance.of(0L));
    }

    public static <T> Shrinkable<T> unshrinkable(T value, ShrinkingDistance distance) {
        return ShrinkableFacade.implementation.unshrinkable(value, distance);
    }

    public T value();

    public ShrinkingSequence<T> shrink(Falsifier<T> var1);

    public ShrinkingDistance distance();

    @API(status=API.Status.INTERNAL, since="1.2.4")
    default public Shrinkable<Object> asGeneric() {
        return this;
    }

    default public <U> Shrinkable<U> map(Function<T, U> mapper) {
        return ShrinkableFacade.implementation.map(this, mapper);
    }

    default public Shrinkable<T> filter(Predicate<T> filter) {
        return ShrinkableFacade.implementation.filter(this, filter);
    }

    default public <U> Shrinkable<U> flatMap(Function<T, Arbitrary<U>> flatMapper, int tries, long randomSeed) {
        return ShrinkableFacade.implementation.flatMap(this, flatMapper, tries, randomSeed);
    }

    @Override
    @API(status=API.Status.INTERNAL)
    default public int compareTo(Shrinkable<T> other) {
        T value;
        int comparison = this.distance().compareTo(other.distance());
        if (comparison == 0 && (value = this.value()) instanceof Comparable) {
            return ((Comparable)value).compareTo(other.value());
        }
        return comparison;
    }

    @API(status=API.Status.INTERNAL)
    default public boolean isSmallerThan(Shrinkable<T> other) {
        return this.distance().compareTo(other.distance()) < 0;
    }

    @API(status=API.Status.INTERNAL)
    default public List<Shrinkable<T>> shrinkingSuggestions() {
        Falsifier<Object> falsifier = ignore -> TryExecutionResult.falsified(null);
        ShrinkingSequence<Object> allDown = this.shrink(falsifier);
        ArrayList<Shrinkable<T>> suggestions = new ArrayList<Shrinkable<T>>();
        while (allDown.next(() -> {}, result -> {})) {
            suggestions.add(allDown.current().shrinkable());
        }
        suggestions.sort(null);
        return suggestions;
    }

    @API(status=API.Status.INTERNAL)
    public static abstract class ShrinkableFacade {
        private static ShrinkableFacade implementation = FacadeLoader.load(ShrinkableFacade.class);

        public abstract <T> Shrinkable<T> unshrinkable(T var1, ShrinkingDistance var2);

        public abstract <T, U> Shrinkable<U> map(Shrinkable<T> var1, Function<T, U> var2);

        public abstract <T> Shrinkable<T> filter(Shrinkable<T> var1, Predicate<T> var2);

        public abstract <T, U> Shrinkable<U> flatMap(Shrinkable<T> var1, Function<T, Arbitrary<U>> var2, int var3, long var4);
    }
}

