/*
 * Decompiled with CFR 0.152.
 */
package net.jqwik.api;

import java.util.function.Predicate;
import net.jqwik.api.FalsificationResult;
import net.jqwik.api.Shrinkable;
import net.jqwik.api.lifecycle.TryExecutionResult;
import org.apiguardian.api.API;

@FunctionalInterface
@API(status=API.Status.STABLE, since="1.0")
public interface Falsifier<T> {
    @API(status=API.Status.INTERNAL)
    public TryExecutionResult execute(T var1);

    @API(status=API.Status.INTERNAL)
    default public FalsificationResult<T> falsify(Shrinkable<T> candidate) {
        try {
            TryExecutionResult executionResult = this.execute(candidate.value());
            switch (executionResult.status()) {
                case FALSIFIED: {
                    return FalsificationResult.falsified(candidate, executionResult.throwable().orElse(null));
                }
                case INVALID: {
                    return FalsificationResult.filtered(candidate);
                }
            }
            return FalsificationResult.notFalsified(candidate);
        }
        catch (Throwable throwable) {
            return FalsificationResult.falsified(candidate, throwable);
        }
    }

    @API(status=API.Status.INTERNAL)
    default public Falsifier<T> withFilter(Predicate<T> filter) {
        return value -> {
            if (!filter.test(value)) {
                return TryExecutionResult.invalid();
            }
            return this.execute(value);
        };
    }

    @API(status=API.Status.INTERNAL)
    default public Falsifier<T> withPostFilter(Predicate<T> filter) {
        return value -> {
            try {
                TryExecutionResult tryExecutionResult = this.execute(value);
                return tryExecutionResult;
            }
            finally {
                if (!filter.test(value)) {
                    return TryExecutionResult.invalid();
                }
            }
        };
    }
}

