/*
 * Decompiled with CFR 0.152.
 */
package net.greghaines.jesque;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import net.greghaines.jesque.Job;
import net.greghaines.jesque.utils.JesqueUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobFailure
implements Serializable {
    private static final long serialVersionUID = -2160045729341301316L;
    private static final Logger LOG = LoggerFactory.getLogger(JobFailure.class);
    @JsonProperty
    private String worker;
    @JsonProperty
    private String queue;
    @JsonProperty
    private Job payload;
    @JsonIgnore
    private Throwable throwable;
    private String throwableString;
    private List<String> backtrace;
    private String error;
    @JsonProperty(value="failed_at")
    private Date failedAt;
    @JsonProperty(value="retried_at")
    private Date retriedAt;

    public JobFailure() {
    }

    public JobFailure(JobFailure origFailure) {
        if (origFailure == null) {
            throw new IllegalArgumentException("origFailure must not be null");
        }
        this.worker = origFailure.worker;
        this.queue = origFailure.queue;
        this.payload = origFailure.payload;
        this.throwable = origFailure.throwable;
        this.failedAt = origFailure.failedAt;
        this.retriedAt = origFailure.retriedAt;
        this.throwableString = origFailure.throwableString;
        this.error = origFailure.error;
        this.backtrace = origFailure.backtrace;
    }

    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }

    public Job getPayload() {
        return this.payload;
    }

    public void setPayload(Job payload) {
        this.payload = payload;
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    @JsonProperty(value="exception")
    public String getThrowableString() {
        return this.throwable == null ? this.throwableString : this.throwable.getClass().getName();
    }

    @JsonProperty(value="exception")
    public void setThrowableString(String throwableString) {
        this.throwableString = throwableString;
        this.tryCreateThrowable();
    }

    @JsonProperty
    public String getError() {
        return this.throwable == null ? this.error : this.throwable.getMessage();
    }

    @JsonProperty
    public void setError(String error) {
        this.error = error;
        this.tryCreateThrowable();
    }

    @JsonProperty
    public List<String> getBacktrace() {
        return this.throwable == null ? this.backtrace : JesqueUtils.createBacktrace(this.throwable);
    }

    @JsonProperty
    public void setBacktrace(List<String> backtrace) {
        this.backtrace = backtrace;
        this.tryCreateThrowable();
    }

    public Date getFailedAt() {
        return this.failedAt;
    }

    public void setFailedAt(Date failedAt) {
        this.failedAt = failedAt;
    }

    public Date getRetriedAt() {
        return this.retriedAt;
    }

    public void setRetriedAt(Date retriedAt) {
        this.retriedAt = retriedAt;
    }

    public String toString() {
        return "JobFailure [worker=" + this.worker + ", queue=" + this.queue + ", payload=" + this.payload + ", throwable=" + this.throwable + ", failedAt=" + this.failedAt + ", retriedAt=" + this.retriedAt + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.throwable == null ? 0 : this.throwable.hashCode());
        result = 31 * result + (this.failedAt == null ? 0 : this.failedAt.hashCode());
        result = 31 * result + (this.retriedAt == null ? 0 : this.retriedAt.hashCode());
        result = 31 * result + (this.payload == null ? 0 : this.payload.hashCode());
        result = 31 * result + (this.worker == null ? 0 : this.worker.hashCode());
        result = 31 * result + (this.queue == null ? 0 : this.queue.hashCode());
        result = 31 * result + (this.throwableString == null ? 0 : this.throwableString.hashCode());
        result = 31 * result + (this.error == null ? 0 : this.error.hashCode());
        result = 31 * result + (this.backtrace == null ? 0 : this.backtrace.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        boolean equal = false;
        if (this == obj) {
            equal = true;
        } else if (obj instanceof JobFailure) {
            JobFailure other = (JobFailure)obj;
            equal = JesqueUtils.nullSafeEquals(this.queue, other.queue) && JesqueUtils.nullSafeEquals(this.worker, other.worker) && JesqueUtils.nullSafeEquals(this.throwableString, other.throwableString) && JesqueUtils.nullSafeEquals(this.error, other.error) && JesqueUtils.nullSafeEquals(this.failedAt, other.failedAt) && JesqueUtils.nullSafeEquals(this.retriedAt, other.retriedAt) && JesqueUtils.equal(this.throwable, other.throwable) && JesqueUtils.nullSafeEquals(this.payload, other.payload) && JesqueUtils.nullSafeEquals(this.backtrace, other.backtrace);
        }
        return equal;
    }

    private void tryCreateThrowable() {
        if (this.throwable == null && this.throwableString != null && this.error != null && this.backtrace != null) {
            try {
                this.throwable = JesqueUtils.recreateThrowable(this.throwableString, this.error, this.backtrace);
            }
            catch (Exception e) {
                LOG.warn("Error while recreating throwable: " + this.throwableString + " " + this.error + " " + this.backtrace, (Throwable)e);
            }
        }
    }
}

