/*
 * Decompiled with CFR 0.152.
 */
package net.engio.mbassy.subscription;

import java.util.Comparator;
import java.util.UUID;
import net.engio.mbassy.bus.MessagePublication;
import net.engio.mbassy.common.ConcurrentSet;
import net.engio.mbassy.dispatch.IMessageDispatcher;
import net.engio.mbassy.subscription.SubscriptionContext;

public class Subscription {
    private UUID id = UUID.randomUUID();
    protected ConcurrentSet<Object> listeners = new ConcurrentSet();
    private IMessageDispatcher dispatcher;
    private SubscriptionContext context;
    public static final Comparator<Subscription> SubscriptionByPriorityDesc = new Comparator<Subscription>(){

        @Override
        public int compare(Subscription o1, Subscription o2) {
            int result = o1.getPriority() - o2.getPriority();
            return result == 0 ? o1.id.compareTo(o2.id) : result;
        }
    };

    public Subscription(SubscriptionContext context, IMessageDispatcher dispatcher) {
        this.context = context;
        this.dispatcher = dispatcher;
    }

    public boolean handlesMessageType(Class<?> messageType) {
        return this.context.getHandlerMetadata().handlesMessage(messageType);
    }

    public void publish(MessagePublication publication, Object message) {
        this.dispatcher.dispatch(publication, message, this.listeners);
    }

    public int getPriority() {
        return this.context.getHandlerMetadata().getPriority();
    }

    public void subscribe(Object o) {
        this.listeners.add(o);
    }

    public boolean unsubscribe(Object existingListener) {
        return this.listeners.remove(existingListener);
    }

    public int size() {
        return this.listeners.size();
    }
}

