/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.jdbc;

import com.mysql.jdbc.ConnectionImpl;
import com.mysql.jdbc.Messages;
import com.mysql.jdbc.MySQLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public interface SocketMetadata {
    public boolean isLocallyConnected(ConnectionImpl var1) throws SQLException;

    public static class Helper {
        public static final String IS_LOCAL_HOSTNAME_REPLACEMENT_PROPERTY_NAME = "com.mysql.jdbc.test.isLocalHostnameReplacement";

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean isLocallyConnected(ConnectionImpl conn) throws SQLException {
            long threadId = conn.getId();
            Statement processListStmt = conn.getMetadataSafeStatement();
            ResultSet rs = null;
            String processHost = null;
            if (System.getProperty(IS_LOCAL_HOSTNAME_REPLACEMENT_PROPERTY_NAME) != null) {
                processHost = System.getProperty(IS_LOCAL_HOSTNAME_REPLACEMENT_PROPERTY_NAME);
            } else if (conn.getProperties().getProperty(IS_LOCAL_HOSTNAME_REPLACEMENT_PROPERTY_NAME) != null) {
                processHost = conn.getProperties().getProperty(IS_LOCAL_HOSTNAME_REPLACEMENT_PROPERTY_NAME);
            } else {
                try {
                    processHost = Helper.findProcessHost(threadId, processListStmt);
                    if (processHost == null) {
                        conn.getLog().logWarn(String.format("Connection id %d not found in \"SHOW PROCESSLIST\", assuming 32-bit overflow, using SELECT CONNECTION_ID() instead", threadId));
                        rs = processListStmt.executeQuery("SELECT CONNECTION_ID()");
                        if (rs.next()) {
                            threadId = rs.getLong(1);
                            processHost = Helper.findProcessHost(threadId, processListStmt);
                        } else {
                            conn.getLog().logError("No rows returned for statement \"SELECT CONNECTION_ID()\", local connection check will most likely be incorrect");
                        }
                    }
                    Object var7_5 = null;
                }
                catch (Throwable throwable) {
                    Object var7_6 = null;
                    processListStmt.close();
                    throw throwable;
                }
                processListStmt.close();
                {
                }
            }
            if (processHost != null) {
                conn.getLog().logDebug(Messages.getString("SocketMetadata.0", new Object[]{processHost}));
                int endIndex = processHost.lastIndexOf(":");
                if (endIndex != -1) {
                    processHost = processHost.substring(0, endIndex);
                }
                try {
                    InetAddress[] allHostAddr = InetAddress.getAllByName(processHost);
                    SocketAddress remoteSocketAddr = conn.getIO().mysqlConnection.getRemoteSocketAddress();
                    if (remoteSocketAddr instanceof InetSocketAddress) {
                        InetAddress whereIConnectedTo = ((InetSocketAddress)remoteSocketAddr).getAddress();
                        for (InetAddress hostAddr : allHostAddr) {
                            if (hostAddr.equals(whereIConnectedTo)) {
                                conn.getLog().logDebug(Messages.getString("SocketMetadata.1", new Object[]{hostAddr, whereIConnectedTo}));
                                return true;
                            }
                            conn.getLog().logDebug(Messages.getString("SocketMetadata.2", new Object[]{hostAddr, whereIConnectedTo}));
                        }
                    } else {
                        conn.getLog().logDebug(Messages.getString("SocketMetadata.3", new Object[]{remoteSocketAddr}));
                    }
                    return false;
                }
                catch (UnknownHostException e) {
                    conn.getLog().logWarn(Messages.getString("Connection.CantDetectLocalConnect", new Object[]{processHost}), e);
                    return false;
                }
            }
            return false;
        }

        private static String findProcessHost(long threadId, Statement processListStmt) throws SQLException {
            ResultSet rs;
            String processHost = null;
            String ps = ((MySQLConnection)processListStmt.getConnection()).getServerVariable("performance_schema");
            ResultSet resultSet = rs = ((MySQLConnection)processListStmt.getConnection()).versionMeetsMinimum(5, 6, 0) && ps != null && ("1".contentEquals(ps) || "ON".contentEquals(ps)) ? processListStmt.executeQuery("select PROCESSLIST_ID, PROCESSLIST_USER, PROCESSLIST_HOST from performance_schema.threads where PROCESSLIST_ID=" + threadId) : processListStmt.executeQuery("SHOW PROCESSLIST");
            while (rs.next()) {
                long id = rs.getLong(1);
                if (threadId != id) continue;
                processHost = rs.getString(3);
                break;
            }
            return processHost;
        }
    }
}

