/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.spi;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.SqlConnectionBase;
import io.vertx.sqlclient.internal.SqlConnectionInternal;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.function.Supplier;

public interface Driver<C extends SqlConnectOptions> {
    default public Pool createPool(Vertx vertx, Supplier<Future<C>> databases, PoolOptions poolOptions, NetClientOptions transportOptions, Handler<SqlConnection> connectHandler) {
        Pool pool;
        VertxInternal vx;
        if (vertx == null) {
            if (Vertx.currentContext() != null) {
                throw new IllegalStateException("Running in a Vertx context => use Pool#pool(Vertx, SqlConnectOptions, PoolOptions) instead");
            }
            vx = (VertxInternal)Vertx.vertx((VertxOptions)new VertxOptions());
        } else {
            vx = (VertxInternal)vertx;
        }
        CloseFuture closeFuture = new CloseFuture();
        try {
            pool = this.newPool((Vertx)vx, databases, poolOptions, transportOptions, connectHandler, closeFuture);
        }
        catch (Exception e) {
            if (vertx == null) {
                vx.close();
            }
            throw e;
        }
        if (vertx == null) {
            closeFuture.future().onComplete(ar -> vx.close());
        } else {
            ContextInternal ctx = vx.getContext();
            if (ctx != null) {
                ctx.addCloseHook((Closeable)closeFuture);
            } else {
                vx.addCloseHook((Closeable)closeFuture);
            }
        }
        return pool;
    }

    public Pool newPool(Vertx var1, Supplier<Future<C>> var2, PoolOptions var3, NetClientOptions var4, Handler<SqlConnection> var5, CloseFuture var6);

    public ConnectionFactory<C> createConnectionFactory(Vertx var1, NetClientOptions var2);

    public SqlConnectOptions parseConnectionUri(String var1);

    public boolean acceptsOptions(SqlConnectOptions var1);

    public C downcast(SqlConnectOptions var1);

    default public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append("?");
        return current;
    }

    default public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory<C> factory, Connection conn) {
        return new SqlConnectionBase(context, factory, conn, this);
    }
}

