/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Completable;
import io.vertx.core.Promise;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.sqlclient.PropertyKind;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.impl.PropertyKindMap;
import io.vertx.sqlclient.impl.SqlResultBase;
import io.vertx.sqlclient.internal.QueryResultHandler;
import io.vertx.sqlclient.internal.RowDesc;
import java.util.function.Function;

public class QueryResultBuilder<T, R extends SqlResultBase<T>, L extends SqlResult<T>>
implements QueryResultHandler<T>,
Completable<Boolean> {
    private final Promise<L> handler;
    private final Function<T, R> factory;
    public R first;
    private R current;
    private Throwable failure;
    private boolean suspended;

    QueryResultBuilder(Function<T, R> factory, PromiseInternal<L> handler) {
        this.factory = factory;
        this.handler = handler;
    }

    @Override
    public void handleResult(int updatedCount, int size, RowDesc desc, T result, Throwable failure) {
        if (failure != null) {
            this.failure = failure;
        } else {
            SqlResultBase r = (SqlResultBase)this.factory.apply(result);
            r.updated = updatedCount;
            r.size = size;
            r.columnNames = desc != null ? desc.columnNames() : null;
            r.columnDescriptors = desc != null ? desc.columnDescriptor() : null;
            this.handleResult(r);
        }
    }

    private void handleResult(R result) {
        R c = this.current;
        if (c == null) {
            this.first = result;
            this.current = result;
        } else {
            ((SqlResultBase)c).next = result;
            this.current = result;
        }
    }

    @Override
    public <V> void addProperty(PropertyKind<V> property, V value) {
        R r = this.current;
        if (r != null) {
            if (((SqlResultBase)r).properties == null) {
                ((SqlResultBase)r).properties = new PropertyKindMap();
            }
            ((SqlResultBase)r).properties.put(property, value);
        }
    }

    public void complete(Boolean aBoolean, Throwable throwable) {
        if (throwable == null) {
            this.suspended = aBoolean;
            if (this.failure != null) {
                this.handler.tryFail(this.failure);
            } else {
                this.handler.tryComplete(this.first);
            }
        } else {
            this.handler.tryFail(throwable);
        }
    }

    public boolean isSuspended() {
        return this.suspended;
    }
}

