/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.sqlclient.Cursor;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.impl.PreparedStatementBase;
import io.vertx.sqlclient.impl.QueryResultBuilder;
import io.vertx.sqlclient.impl.RowSetImpl;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.TupleInternal;
import java.util.UUID;

public class CursorImpl
implements Cursor {
    private final Connection conn;
    private final PreparedStatementBase ps;
    private final ContextInternal context;
    private final boolean autoCommit;
    private final TupleInternal params;
    private String id;
    private boolean closed;
    QueryResultBuilder<RowSet<Row>, RowSetImpl<Row>, RowSet<Row>> result;

    CursorImpl(PreparedStatementBase ps, Connection conn, ContextInternal context, boolean autoCommit, TupleInternal params) {
        this.ps = ps;
        this.conn = conn;
        this.context = context;
        this.autoCommit = autoCommit;
        this.params = params;
    }

    @Override
    public synchronized boolean hasMore() {
        if (this.result == null) {
            throw new IllegalStateException("No current cursor read");
        }
        return this.result.isSuspended();
    }

    @Override
    public synchronized Future<RowSet<Row>> read(int count) {
        boolean suspended;
        PromiseInternal promise = this.context.promise();
        if (this.id == null) {
            this.id = UUID.randomUUID().toString();
            suspended = false;
        } else {
            suspended = true;
        }
        this.ps.readCursor(this, this.id, suspended, this.params, count, (PromiseInternal<RowSet<Row>>)promise);
        return promise.future();
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public synchronized Future<Void> close() {
        PromiseInternal promise = this.context.promise();
        this.close((Promise<Void>)promise);
        return promise.future();
    }

    private synchronized void close(Promise<Void> promise) {
        if (!this.closed) {
            this.closed = true;
            if (this.id == null) {
                promise.complete();
            } else {
                String id = this.id;
                this.id = null;
                this.result = null;
                this.ps.closeCursor(id, promise);
            }
        }
    }
}

