/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.sqlclient.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetClientOptions;
import io.vertx.sqlclient.ClientBuilder;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.SingletonSupplier;
import io.vertx.sqlclient.impl.Utils;
import io.vertx.sqlclient.spi.Driver;
import java.util.List;
import java.util.function.Supplier;

public abstract class ClientBuilderBase<C>
implements ClientBuilder<C> {
    protected final Driver<SqlConnectOptions> driver;
    private PoolOptions poolOptions;
    private NetClientOptions transportOptions;
    private Supplier<Future<SqlConnectOptions>> database;
    private Handler<SqlConnection> connectHandler;
    private Vertx vertx;

    public ClientBuilderBase(Driver<?> driver) {
        this.driver = driver;
    }

    @Override
    public ClientBuilder<C> with(PoolOptions options) {
        this.poolOptions = options;
        return this;
    }

    @Override
    public ClientBuilder<C> with(NetClientOptions options) {
        this.transportOptions = options;
        return this;
    }

    @Override
    public ClientBuilder<C> connectingTo(SqlConnectOptions database) {
        return this.connectingTo(SingletonSupplier.wrap(database));
    }

    @Override
    public ClientBuilder<C> connectingTo(String database) {
        return this.connectingTo(this.driver.parseConnectionUri(database));
    }

    @Override
    public ClientBuilder<C> connectingTo(Supplier<Future<SqlConnectOptions>> supplier) {
        this.database = supplier;
        return this;
    }

    @Override
    public ClientBuilder<C> connectingTo(List<SqlConnectOptions> databases) {
        return this.connectingTo(Utils.roundRobinSupplier(databases));
    }

    @Override
    public ClientBuilder<C> withConnectHandler(Handler<SqlConnection> handler) {
        this.connectHandler = handler;
        return this;
    }

    @Override
    public ClientBuilder<C> using(Vertx vertx) {
        this.vertx = vertx;
        return this;
    }

    @Override
    public final C build() {
        NetClientOptions transportOptions;
        PoolOptions poolOptions = this.poolOptions;
        if (poolOptions == null) {
            poolOptions = new PoolOptions();
        }
        if ((transportOptions = this.transportOptions) == null) {
            transportOptions = new NetClientOptions();
        }
        C c = this.create(this.vertx, this.database, poolOptions, transportOptions, this.connectHandler);
        return c;
    }

    protected abstract C create(Vertx var1, Supplier<Future<SqlConnectOptions>> var2, PoolOptions var3, NetClientOptions var4, Handler<SqlConnection> var5);
}

