/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.httpproxy.impl;

import io.vertx.core.Future;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.net.NetSocket;
import io.vertx.httpproxy.HttpProxy;
import io.vertx.httpproxy.OriginRequestProvider;
import io.vertx.httpproxy.ProxyContext;
import io.vertx.httpproxy.ProxyInterceptor;
import io.vertx.httpproxy.ProxyOptions;
import io.vertx.httpproxy.ProxyRequest;
import io.vertx.httpproxy.ProxyResponse;
import io.vertx.httpproxy.cache.CacheOptions;
import io.vertx.httpproxy.impl.CachingFilter;
import io.vertx.httpproxy.impl.HttpUtils;
import io.vertx.httpproxy.impl.Resource;
import io.vertx.httpproxy.spi.cache.Cache;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;

public class ReverseProxy
implements HttpProxy {
    private static final Logger log = LoggerFactory.getLogger(ReverseProxy.class);
    private final HttpClient client;
    private final boolean supportWebSocket;
    private OriginRequestProvider originRequestProvider = pc -> Future.failedFuture((String)"No origin available");
    private final List<ProxyInterceptor> interceptors = new ArrayList<ProxyInterceptor>();

    public ReverseProxy(ProxyOptions options, HttpClient client) {
        CacheOptions cacheOptions = options.getCacheOptions();
        if (cacheOptions != null) {
            Cache<String, Resource> cache = cacheOptions.newCache();
            this.addInterceptor(new CachingFilter(cache));
        }
        this.client = client;
        this.supportWebSocket = options.getSupportWebSocket();
    }

    @Override
    public HttpProxy origin(OriginRequestProvider provider) {
        this.originRequestProvider = Objects.requireNonNull(provider);
        return this;
    }

    @Override
    public HttpProxy addInterceptor(ProxyInterceptor interceptor) {
        this.interceptors.add(interceptor);
        return this;
    }

    @Override
    public void handle(HttpServerRequest request) {
        ProxyRequest proxyRequest = ProxyRequest.reverseProxy(request);
        Boolean chunked = HttpUtils.isChunked(request.headers());
        if (chunked == null) {
            this.end(proxyRequest, 400);
            return;
        }
        Proxy proxy = new Proxy(proxyRequest);
        if (this.supportWebSocket && io.vertx.core.http.impl.HttpUtils.canUpgradeToWebSocket((HttpServerRequest)request)) {
            this.handleWebSocketUpgrade(proxy);
            return;
        }
        proxy.filters = this.interceptors.listIterator();
        proxy.sendRequest().recover(throwable -> {
            log.trace((Object)"Error in sending the request", throwable);
            return Future.succeededFuture((Object)proxyRequest.release().response().setStatusCode(502));
        }).compose(x$0 -> proxy.sendProxyResponse(x$0)).recover(throwable -> {
            log.trace((Object)"Error in sending the response", throwable);
            return proxy.response().release().setStatusCode(502).send();
        });
    }

    private void handleWebSocketUpgrade(ProxyContext proxyContext) {
        ProxyRequest proxyRequest = proxyContext.request();
        HttpServerRequest proxiedRequest = proxyRequest.proxiedRequest();
        this.resolveOrigin(proxyContext).onComplete(ar -> {
            if (ar.succeeded()) {
                HttpClientRequest request = (HttpClientRequest)ar.result();
                request.setMethod(HttpMethod.GET);
                request.setURI(proxiedRequest.uri());
                request.headers().addAll(proxiedRequest.headers()).set(HttpHeaders.CONNECTION, HttpHeaders.UPGRADE);
                Future fut2 = request.connect();
                proxiedRequest.handler(arg_0 -> ((HttpClientRequest)request).write(arg_0));
                proxiedRequest.endHandler(v -> request.end());
                proxiedRequest.resume();
                fut2.onComplete(ar2 -> {
                    if (ar2.succeeded()) {
                        HttpClientResponse proxiedResponse = (HttpClientResponse)ar2.result();
                        if (proxiedResponse.statusCode() == 101) {
                            HttpServerResponse response = proxiedRequest.response();
                            response.setStatusCode(101);
                            response.headers().addAll(proxiedResponse.headers());
                            Future otherso = proxiedRequest.toNetSocket();
                            otherso.onComplete(ar3 -> {
                                if (ar3.succeeded()) {
                                    NetSocket responseSocket = (NetSocket)ar3.result();
                                    NetSocket proxyResponseSocket = proxiedResponse.netSocket();
                                    responseSocket.handler(arg_0 -> ((NetSocket)proxyResponseSocket).write(arg_0));
                                    proxyResponseSocket.handler(arg_0 -> ((NetSocket)responseSocket).write(arg_0));
                                    responseSocket.closeHandler(v -> proxyResponseSocket.close());
                                    proxyResponseSocket.closeHandler(v -> responseSocket.close());
                                } else {
                                    System.err.println("Handle this case");
                                    ar3.cause().printStackTrace();
                                }
                            });
                        } else {
                            proxiedRequest.resume();
                            this.end(proxyRequest, proxiedResponse.statusCode());
                        }
                    } else {
                        proxiedRequest.resume();
                        this.end(proxyRequest, 502);
                    }
                });
            } else {
                proxiedRequest.resume();
                this.end(proxyRequest, 502);
            }
        });
    }

    private void end(ProxyRequest proxyRequest, int sc) {
        proxyRequest.response().release().setStatusCode(sc).putHeader(HttpHeaders.CONTENT_LENGTH, "0").setBody(null).send();
    }

    private Future<HttpClientRequest> resolveOrigin(ProxyContext proxyContext) {
        return this.originRequestProvider.create(proxyContext);
    }

    private class Proxy
    implements ProxyContext {
        private final ProxyRequest request;
        private ProxyResponse response;
        private final Map<String, Object> attachments = new HashMap<String, Object>();
        private ListIterator<ProxyInterceptor> filters;

        private Proxy(ProxyRequest request) {
            this.request = request;
        }

        @Override
        public void set(String name, Object value) {
            this.attachments.put(name, value);
        }

        @Override
        public <T> T get(String name, Class<T> type) {
            Object o = this.attachments.get(name);
            return type.isInstance(o) ? (T)type.cast(o) : null;
        }

        @Override
        public HttpClient client() {
            return ReverseProxy.this.client;
        }

        @Override
        public ProxyRequest request() {
            return this.request;
        }

        @Override
        public Future<ProxyResponse> sendRequest() {
            if (this.filters.hasNext()) {
                ProxyInterceptor next = this.filters.next();
                return next.handleProxyRequest(this);
            }
            return this.sendProxyRequest(this.request);
        }

        @Override
        public ProxyResponse response() {
            return this.response;
        }

        @Override
        public Future<Void> sendResponse() {
            if (this.filters.hasPrevious()) {
                ProxyInterceptor filter = this.filters.previous();
                return filter.handleProxyResponse(this);
            }
            return this.response.send();
        }

        private Future<ProxyResponse> sendProxyRequest(ProxyRequest proxyRequest) {
            return ReverseProxy.this.resolveOrigin(this).compose(proxyRequest::send);
        }

        private Future<Void> sendProxyResponse(ProxyResponse response) {
            this.response = response;
            Boolean chunked = HttpUtils.isChunked(response.headers());
            if (chunked == null) {
                ReverseProxy.this.end(response.request(), 501);
                return Future.succeededFuture();
            }
            return this.sendResponse();
        }
    }
}

