/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.dns;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.dns.MxRecord;
import io.vertx.core.dns.SrvRecord;
import io.vertx.core.dns.impl.DnsClientImpl;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;

@VertxGen
public interface DnsClient {
    public Future<@Nullable String> lookup(String var1);

    public Future<@Nullable String> lookup4(String var1);

    public Future<@Nullable String> lookup6(String var1);

    public Future<List<String>> resolveA(String var1);

    public Future<List<String>> resolveAAAA(String var1);

    public Future<List<String>> resolveCNAME(String var1);

    public Future<List<MxRecord>> resolveMX(String var1);

    public Future<List<String>> resolveTXT(String var1);

    public Future<@Nullable String> resolvePTR(String var1);

    public Future<List<String>> resolveNS(String var1);

    public Future<List<SrvRecord>> resolveSRV(String var1);

    default public Future<@Nullable String> reverseLookup(String ipaddress) {
        try {
            InetAddress inetAddress = InetAddress.getByName(ipaddress);
            byte[] addr = inetAddress.getAddress();
            StringBuilder reverseName = new StringBuilder(64);
            if (inetAddress instanceof Inet4Address) {
                reverseName.append(addr[3] & 0xFF).append(".").append(addr[2] & 0xFF).append(".").append(addr[1] & 0xFF).append(".").append(addr[0] & 0xFF);
            } else {
                for (int i = 0; i < 16; ++i) {
                    reverseName.append(DnsClientImpl.HEX_TABLE[addr[15 - i] & 0xF]);
                    reverseName.append(".");
                    reverseName.append(DnsClientImpl.HEX_TABLE[addr[15 - i] >> 4 & 0xF]);
                    if (i == 15) continue;
                    reverseName.append(".");
                }
            }
            reverseName.append(".in-addr.arpa");
            return this.resolvePTR(reverseName.toString());
        }
        catch (UnknownHostException e) {
            return Future.failedFuture(e);
        }
    }

    public Future<Void> close();
}

