/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.parser.core.models.AuthorizationValue;
import io.swagger.v3.parser.models.RefFormat;
import io.swagger.v3.parser.processors.ExternalRefProcessor;
import io.swagger.v3.parser.util.ClasspathHelper;
import io.swagger.v3.parser.util.RemoteUrl;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class RefUtils {
    private static final String REFERENCE_SEPARATOR = "#/";

    private RefUtils() {
    }

    public static String computeDefinitionName(String ref) {
        String plausibleName;
        String definitionPath;
        String[] refParts = ref.split(REFERENCE_SEPARATOR);
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String string = definitionPath = refParts.length == 2 ? refParts[1] : null;
        if (definitionPath != null) {
            String[] jsonPathElements = definitionPath.split("/");
            plausibleName = jsonPathElements[jsonPathElements.length - 1];
        } else {
            String[] filePathElements = file.split("/");
            plausibleName = filePathElements[filePathElements.length - 1];
            String[] split = plausibleName.split("\\.");
            plausibleName = split.length > 2 ? String.join((CharSequence)"", Arrays.copyOf(split, split.length - 1)) : split[0];
        }
        return plausibleName;
    }

    public static Optional<String> getExternalPath(String ref) {
        if (ref == null) {
            return Optional.empty();
        }
        return Optional.of(ref.split(REFERENCE_SEPARATOR)).filter(it -> ((String[])it).length == 2).map(it -> it[0]).filter(it -> !it.isEmpty());
    }

    public static boolean isAnExternalRefFormat(RefFormat refFormat) {
        return refFormat == RefFormat.URL || refFormat == RefFormat.RELATIVE;
    }

    public static RefFormat computeRefFormat(String ref) {
        RefFormat result = RefFormat.INTERNAL;
        if ((ref = RefUtils.mungedRef(ref)).startsWith("http") || ref.startsWith("https")) {
            result = RefFormat.URL;
        } else if (ref.startsWith(REFERENCE_SEPARATOR)) {
            result = RefFormat.INTERNAL;
        } else if (ref.startsWith(".") || ref.startsWith("/") || ref.indexOf(REFERENCE_SEPARATOR) > 0) {
            result = RefFormat.RELATIVE;
        }
        return result;
    }

    public static String mungedRef(String refString) {
        if (!(refString.contains(":") || refString.startsWith("#") || refString.startsWith("/") || refString.contains("$") || refString.indexOf(".") <= 0)) {
            return "./" + refString;
        }
        return refString;
    }

    public static String readExternalUrlRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, String rootPath) {
        String result;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat != RefFormat.URL) {
                String url = RefUtils.buildUrl(rootPath, file);
                return RefUtils.readExternalRef(url, RefFormat.URL, auths, null);
            }
            result = RemoteUrl.urlToString(file, auths);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file, e);
        }
        return result;
    }

    public static String readExternalClasspathRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, String rootPath) {
        String result;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat == RefFormat.URL) {
                result = RemoteUrl.urlToString(file, auths);
            } else {
                String pathRef = ExternalRefProcessor.join(rootPath, file);
                result = ClasspathHelper.loadFileFromClasspath(pathRef);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file, e);
        }
        return result;
    }

    public static String buildUrl(String rootPath, String relativePath) {
        if (rootPath == null || relativePath == null) {
            return null;
        }
        try {
            int until = rootPath.lastIndexOf("/") + 1;
            String root = rootPath.substring(0, until);
            URL rootUrl = new URL(root);
            URL finalUrl = new URL(rootUrl, relativePath);
            return finalUrl.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String readExternalRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, Path parentDirectory) {
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        String result = null;
        try {
            if (refFormat == RefFormat.URL) {
                result = RemoteUrl.urlToString(file, auths);
            } else {
                Path pathToUse = parentDirectory.resolve(file).normalize();
                if (Files.exists(pathToUse, new LinkOption[0])) {
                    result = RefUtils.readAll(pathToUse);
                } else {
                    String url = file;
                    if (url.contains("..")) {
                        int parentCount = 0;
                        while (url.contains("..")) {
                            url = url.substring(url.indexOf(".") + 2);
                            ++parentCount;
                        }
                        for (int i = 0; i < parentCount - 1; ++i) {
                            parentDirectory = parentDirectory.getParent();
                        }
                        url = parentDirectory + url;
                    } else {
                        url = parentDirectory + url.substring(url.indexOf(".") + 1);
                    }
                    Path pathToUse2 = parentDirectory.resolve(url).normalize();
                    if (Files.exists(pathToUse2, new LinkOption[0])) {
                        result = RefUtils.readAll(pathToUse2);
                    }
                }
                if (result == null) {
                    result = ClasspathHelper.loadFileFromClasspath(file);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + (Object)((Object)refFormat) + " ref: " + file + " path: " + parentDirectory, e);
        }
        return result;
    }

    private static String readAll(Path path) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(path.toFile());){
            String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }
}

