/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.templates;

import com.samskivert.mustache.Mustache;
import com.samskivert.mustache.Template;
import io.swagger.codegen.v3.CodegenConfig;
import io.swagger.codegen.v3.templates.TemplateEngine;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MustacheTemplateEngine
implements TemplateEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(MustacheTemplateEngine.class);
    private CodegenConfig config;

    public MustacheTemplateEngine(CodegenConfig config) {
        this.config = config;
    }

    @Override
    public String getRendered(String templateFile, Map<String, Object> templateData) throws IOException {
        String template = this.readTemplate(templateFile);
        Mustache.Compiler compiler = Mustache.compiler();
        compiler = this.config.processCompiler(compiler);
        Template tmpl = compiler.withLoader(name -> {
            String fullTemplateFile = this.getFullTemplateFile(this.config, name + ".mustache");
            return this.getTemplateReader(fullTemplateFile);
        }).defaultValue("").compile(template);
        return tmpl.execute(templateData);
    }

    @Override
    public String getName() {
        return "mustache";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readTemplate(String name) {
        Reader reader = this.getTemplateReader(name);
        try {
            if (reader == null) {
                throw new RuntimeException("no file found");
            }
            Scanner scanner = new Scanner(reader).useDelimiter("\\A");
            String string = scanner.hasNext() ? scanner.next() : "";
            return string;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
        }
        throw new RuntimeException("can't load template " + name);
    }

    public Reader getTemplateReader(String name) {
        try {
            InputStream is = this.getClass().getClassLoader().getResourceAsStream(this.getClassResourcePath(name));
            if (is == null) {
                is = new FileInputStream(new File(name));
            }
            return new InputStreamReader(is, "UTF-8");
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            throw new RuntimeException("can't load template " + name);
        }
    }

    public String getFullTemplateFile(CodegenConfig config, String templateFile) {
        String library = config.getLibrary();
        String libTemplateFile = config.customTemplateDir() + File.separator + "libraries" + File.separator + templateFile;
        if (StringUtils.isNotEmpty((CharSequence)library) && new File(libTemplateFile).exists()) {
            return libTemplateFile;
        }
        String template = config.customTemplateDir() + File.separator + templateFile;
        if (new File(template).exists()) {
            return template;
        }
        if (StringUtils.isNotEmpty((CharSequence)library) && this.getClass().getClassLoader().getResource(this.getClassResourcePath(libTemplateFile)) != null) {
            return libTemplateFile;
        }
        return config.embeddedTemplateDir() + File.separator + templateFile;
    }

    public String getClassResourcePath(String name) {
        if (!"/".equals(File.separator)) {
            return name.replaceAll(Pattern.quote(File.separator), "/");
        }
        return name;
    }
}

