/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.nodejs;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import io.swagger.codegen.v3.CliOption;
import io.swagger.codegen.v3.CodegenContent;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenResponse;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.OperationParameters;
import io.swagger.codegen.v3.utils.URLPathUtil;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.info.Info;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeJSServerCodegen
extends DefaultCodegenConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(NodeJSServerCodegen.class);
    protected String implFolder = "service";
    public static final String GOOGLE_CLOUD_FUNCTIONS = "googleCloudFunctions";
    public static final String EXPORTED_NAME = "exportedName";
    protected String apiVersion = "1.0.0";
    protected int serverPort = 8080;
    protected String projectName = "swagger-server";
    protected boolean googleCloudFunctions;
    protected String exportedName;

    public NodeJSServerCodegen() {
        this.outputFolder = "generated-code/nodejs";
        this.modelTemplateFiles.clear();
        this.apiTemplateFiles.put("controller.mustache", ".js");
        this.setReservedWordsLowerCase(Arrays.asList("break", "case", "class", "catch", "const", "continue", "debugger", "default", "delete", "do", "else", "export", "extends", "finally", "for", "function", "if", "import", "in", "instanceof", "let", "new", "return", "super", "switch", "this", "throw", "try", "typeof", "var", "void", "while", "with", "yield"));
        this.additionalProperties.put("apiVersion", this.apiVersion);
        this.additionalProperties.put("serverPort", this.serverPort);
        this.additionalProperties.put("implFolder", this.implFolder);
        this.supportingFiles.add(new SupportingFile("writer.mustache", "utils".replace(".", "/"), "writer.js"));
        this.cliOptions.add(CliOption.newBoolean((String)GOOGLE_CLOUD_FUNCTIONS, (String)"When specified, it will generate the code which runs within Google Cloud Functions instead of standalone Node.JS server. See https://cloud.google.com/functions/docs/quickstart for the details of how to deploy the generated code."));
        this.cliOptions.add(new CliOption(EXPORTED_NAME, "When the generated code will be deployed to Google Cloud Functions, this option can be used to update the name of the exported function. By default, it refers to the basePath. This does not affect normal standalone nodejs server code."));
    }

    @Override
    public String apiPackage() {
        return "controllers";
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "nodejs-server";
    }

    public String getHelp() {
        return "Generates a nodejs server library using the swagger-tools project.  By default, it will also generate service classes--which you can disable with the `-Dnoservice` environment variable.";
    }

    @Override
    public String toApiName(String name) {
        if (name.length() == 0) {
            return "DefaultController";
        }
        return this.initialCaps(name);
    }

    @Override
    public String toApiFilename(String name) {
        return this.toApiName(name);
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        String result = super.apiFilename(templateName, tag);
        if (templateName.equals("service.mustache")) {
            String stringToMatch = File.separator + "controllers" + File.separator;
            String replacement = File.separator + this.implFolder + File.separator;
            result = StringUtils.replace((String)result, (String)stringToMatch, (String)replacement);
        }
        return result;
    }

    @Override
    public String getDefaultTemplateDir() {
        return "nodejs";
    }

    private String implFileFolder(String output) {
        return this.outputFolder + "/" + output + "/" + this.apiPackage().replace('.', '/');
    }

    @Override
    public String escapeReservedWord(String name) {
        if (this.reservedWordsMappings().containsKey(name)) {
            return this.reservedWordsMappings().get(name);
        }
        return "_" + name;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.apiPackage().replace('.', File.separatorChar);
    }

    public boolean getGoogleCloudFunctions() {
        return this.googleCloudFunctions;
    }

    public void setGoogleCloudFunctions(boolean value) {
        this.googleCloudFunctions = value;
    }

    public String getExportedName() {
        return this.exportedName;
    }

    public void setExportedName(String name) {
        this.exportedName = name;
    }

    @Override
    public Map<String, Object> postProcessOperations(Map<String, Object> objs) {
        Map objectMap = (Map)objs.get("operations");
        List operations = (List)objectMap.get("operation");
        for (CodegenOperation operation : operations) {
            List responses;
            operation.httpMethod = operation.httpMethod.toLowerCase();
            List params = operation.allParams;
            if (params != null && params.size() == 0) {
                operation.allParams = null;
            }
            if ((responses = operation.responses) != null) {
                for (CodegenResponse resp : responses) {
                    if (!"0".equals(resp.code)) continue;
                    resp.code = "default";
                }
            }
            if (operation.examples == null || operation.examples.isEmpty()) continue;
            Iterator it = operation.examples.iterator();
            while (it.hasNext()) {
                Map example = (Map)it.next();
                String contentType = (String)example.get("contentType");
                if (contentType != null && contentType.startsWith("application/json")) continue;
                it.remove();
            }
        }
        return objs;
    }

    private static List<Map<String, Object>> getOperations(Map<String, Object> objs) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Map apiInfo = (Map)objs.get("apiInfo");
        List apis = (List)apiInfo.get("apis");
        for (Map api : apis) {
            result.add((Map)api.get("operations"));
        }
        return result;
    }

    private static List<Map<String, Object>> sortOperationsByPath(List<CodegenOperation> ops) {
        ArrayListMultimap opsByPath = ArrayListMultimap.create();
        for (CodegenOperation op : ops) {
            opsByPath.put((Object)op.path, (Object)op);
        }
        ArrayList<Map<String, Object>> opsByPathList = new ArrayList<Map<String, Object>>();
        for (Map.Entry entry : opsByPath.asMap().entrySet()) {
            HashMap<String, Object> opsByPathEntry = new HashMap<String, Object>();
            opsByPathList.add(opsByPathEntry);
            opsByPathEntry.put("path", entry.getKey());
            opsByPathEntry.put("operation", entry.getValue());
            ArrayList operationsForThisPath = Lists.newArrayList((Iterable)((Iterable)entry.getValue()));
            ((CodegenOperation)operationsForThisPath.get(operationsForThisPath.size() - 1)).getVendorExtensions().put("x-has-more", Boolean.FALSE);
            if (opsByPathList.size() >= opsByPath.asMap().size()) continue;
            opsByPathEntry.put("hasMore", "true");
        }
        return opsByPathList;
    }

    @Override
    public void processOpts() {
        super.processOpts();
        if (this.additionalProperties.containsKey(GOOGLE_CLOUD_FUNCTIONS)) {
            this.setGoogleCloudFunctions(Boolean.valueOf(this.additionalProperties.get(GOOGLE_CLOUD_FUNCTIONS).toString()));
        }
        if (this.additionalProperties.containsKey(EXPORTED_NAME)) {
            this.setExportedName((String)this.additionalProperties.get(EXPORTED_NAME));
        }
        this.supportingFiles.add(new SupportingFile("swagger.mustache", "api", "openapi.yaml"));
        if (this.getGoogleCloudFunctions()) {
            this.writeOptional(this.outputFolder, new SupportingFile("index-gcf.mustache", "", "index.js"));
        } else {
            this.writeOptional(this.outputFolder, new SupportingFile("index.mustache", "", "index.js"));
        }
        this.writeOptional(this.outputFolder, new SupportingFile("package.mustache", "", "package.json"));
        this.writeOptional(this.outputFolder, new SupportingFile("README.mustache", "", "README.md"));
        if (System.getProperty("noservice") == null) {
            this.apiTemplateFiles.put("service.mustache", "Service.js");
        }
    }

    @Override
    public void preprocessOpenAPI(OpenAPI openAPI) {
        Paths paths;
        Info info;
        this.openAPI = openAPI;
        URL url = URLPathUtil.getServerURL((OpenAPI)openAPI);
        String host = "http://localhost:8080";
        String port = "8080";
        String basePath = null;
        if (url != null) {
            host = url.getHost();
            basePath = url.getPath();
        }
        this.additionalProperties.put("serverPort", port);
        if (openAPI.getInfo() != null && (info = openAPI.getInfo()).getTitle() != null) {
            this.projectName = info.getTitle().replaceAll("[^a-zA-Z0-9]", "-").replaceAll("^[-]*", "").replaceAll("[-]*$", "").replaceAll("[-]{2,}", "-").toLowerCase();
            this.additionalProperties.put("projectName", this.projectName);
        }
        if (this.getGoogleCloudFunctions()) {
            if (!host.endsWith(".cloudfunctions.net")) {
                LOGGER.warn("Host " + host + " seems not matching with cloudfunctions.net URL.");
            }
            if (!this.additionalProperties.containsKey(EXPORTED_NAME)) {
                if (basePath == null || basePath.equals("/")) {
                    LOGGER.warn("Cannot find the exported name properly. Using 'openapi' as the exported name");
                    basePath = "/openapi";
                }
                this.additionalProperties.put(EXPORTED_NAME, basePath.substring(1));
            }
        }
        if ((paths = openAPI.getPaths()) != null) {
            for (String pathname : paths.keySet()) {
                PathItem path = (PathItem)paths.get((Object)pathname);
                Map operationMap = path.readOperationsMap();
                if (operationMap == null) continue;
                for (PathItem.HttpMethod method : operationMap.keySet()) {
                    Operation operation = (Operation)operationMap.get(method);
                    String tag = "default";
                    if (operation.getTags() != null && operation.getTags().size() > 0) {
                        tag = this.toApiName((String)operation.getTags().get(0));
                    }
                    if (operation.getOperationId() == null) {
                        operation.setOperationId(this.getOrGenerateOperationId(operation, pathname, method.toString()));
                    }
                    if (operation.getExtensions() == null) {
                        operation.setExtensions(new HashMap());
                    }
                    if (operation.getExtensions() == null || operation.getExtensions().get("x-swagger-router-controller") != null) continue;
                    operation.getExtensions().put("x-swagger-router-controller", this.sanitizeTag(tag));
                }
            }
        }
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        if (openAPI != null) {
            try {
                SimpleModule module = new SimpleModule();
                module.addSerializer(Double.class, (JsonSerializer)new JsonSerializer<Double>(){

                    public void serialize(Double val, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
                        jgen.writeNumber(new BigDecimal(val));
                    }
                });
                objs.put("swagger-yaml", Yaml.mapper().registerModule((Module)module).writeValueAsString((Object)openAPI));
            }
            catch (JsonProcessingException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        for (Map<String, Object> operations : NodeJSServerCodegen.getOperations(objs)) {
            List ops = (List)operations.get("operation");
            List<Map<String, Object>> opsByPathList = NodeJSServerCodegen.sortOperationsByPath(ops);
            operations.put("operationsByPath", opsByPathList);
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    public String removeNonNameElementToCamelCase(String name) {
        return this.removeNonNameElementToCamelCase(name, "[-:;#]");
    }

    @Override
    public String escapeUnsafeCharacters(String input) {
        return input.replace("*/", "*_/").replace("/*", "/_*");
    }

    @Override
    public String escapeQuotationMark(String input) {
        return input.replace("\"", "");
    }

    @Override
    protected void configuresParameterForMediaType(CodegenOperation codegenOperation, List<CodegenContent> codegenContents) {
        if (codegenContents.isEmpty()) {
            CodegenContent content = new CodegenContent();
            content.getParameters().addAll(codegenOperation.allParams);
            codegenContents.add(content);
            codegenOperation.getContents().add(content);
            return;
        }
        for (CodegenContent content : codegenContents) {
            this.addParameters(content, codegenOperation.bodyParams);
            this.addParameters(content, codegenOperation.queryParams);
            this.addParameters(content, codegenOperation.pathParams);
            this.addParameters(content, codegenOperation.headerParams);
            this.addParameters(content, codegenOperation.cookieParams);
        }
        for (CodegenContent content : codegenContents) {
            OperationParameters.addHasMore(content.getParameters());
        }
        codegenOperation.getContents().addAll(codegenContents);
    }
}

