/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.handlebars.lambda;

import com.github.jknack.handlebars.Lambda;
import com.github.jknack.handlebars.Template;
import java.io.IOException;

public class TitlecaseLambda
implements Lambda {
    private String delimiter;

    public TitlecaseLambda() {
        this(" ");
    }

    public TitlecaseLambda(String delimiter) {
        this.delimiter = delimiter;
    }

    private String titleCase(String input) {
        return input.substring(0, 1).toUpperCase() + input.substring(1);
    }

    public Object apply(Object o, Template template) throws IOException {
        String text = template.apply(o);
        if (text == null || text.length() == 0) {
            return text;
        }
        if (this.delimiter == null) {
            return this.titleCase(text);
        }
        StringBuffer sb = new StringBuffer();
        String[] parts = text.split("\\Q" + this.delimiter + "\\E");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            sb.append(this.titleCase(part));
            if (i == parts.length - 1) continue;
            sb.append(this.delimiter);
        }
        return sb.toString();
    }
}

