/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.builder.internal.processor;

import io.sundr.builder.Constants;
import io.sundr.builder.annotations.Inline;
import io.sundr.builder.internal.BuilderContext;
import io.sundr.builder.internal.BuilderContextManager;
import io.sundr.builder.internal.functions.TypeAs;
import io.sundr.builder.internal.utils.BuilderUtils;
import io.sundr.codegen.model.EditableJavaMethod;
import io.sundr.codegen.model.EditableJavaProperty;
import io.sundr.codegen.model.EditableJavaType;
import io.sundr.codegen.model.JavaClazz;
import io.sundr.codegen.model.JavaClazzBuilder;
import io.sundr.codegen.model.JavaMethod;
import io.sundr.codegen.model.JavaMethodBuilder;
import io.sundr.codegen.model.JavaMethodFluent;
import io.sundr.codegen.model.JavaProperty;
import io.sundr.codegen.model.JavaPropertyBuilder;
import io.sundr.codegen.model.JavaType;
import io.sundr.codegen.model.JavaTypeBuilder;
import io.sundr.codegen.processor.JavaGeneratingProcessor;
import io.sundr.codegen.utils.StringUtils;
import io.sundr.codegen.utils.TypeUtils;
import java.util.LinkedHashSet;
import javax.lang.model.element.Modifier;

public abstract class AbstractBuilderProcessor
extends JavaGeneratingProcessor {
    private static final String EMPTY_FUNCTION_TEXT = StringUtils.loadResourceQuietly((String)"snippets/empty-function.txt");

    void generateLocalDependenciesIfNeeded() {
        BuilderContext context = BuilderContextManager.getContext();
        if (context.getGenerateBuilderPackage().booleanValue() && !"io.sundr.builder".equals(context.getBuilderPackage())) {
            try {
                this.generateFromClazz(context.getVisitableInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getVisitorInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getVisitableBuilderInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getBuilderInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getFluentInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getBaseFluentClass(), "templates/builder/class.vm");
                this.generateFromClazz(context.getNestedInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getEditableInterface(), "templates/builder/interface.vm");
                this.generateFromClazz(context.getFunctionInterface(), "templates/builder/interface.vm");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    String selectBuilderTemplate(boolean validationEnabled) {
        if (validationEnabled) {
            return "templates/builder/validating-builder.vm";
        }
        return "templates/builder/builder.vm";
    }

    JavaClazz inlineableOf(BuilderContext ctx, JavaClazz clazz, Inline inline) {
        JavaType returnType;
        LinkedHashSet<EditableJavaMethod> constructors = new LinkedHashSet<EditableJavaMethod>();
        JavaType type = clazz.getType();
        JavaType builderType = (JavaType)TypeAs.SHALLOW_BUILDER.apply(type);
        JavaType inlineableType = (JavaType)TypeAs.INLINEABLE.apply(type);
        if (!inline.name().isEmpty()) {
            inlineableType = ((JavaTypeBuilder)new JavaTypeBuilder(inlineableType).withClassName(inline.name())).build();
        }
        if ((returnType = BuilderUtils.getInlineReturnType(ctx, inline)).equals((Object)Constants.BOXED_VOID)) {
            returnType = clazz.getType();
        }
        JavaType functionType = TypeUtils.typeGenericOf((JavaType)ctx.getFunctionInterface().getType(), (JavaType[])new JavaType[]{clazz.getType(), returnType});
        EditableJavaProperty builderProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withType((JavaType)TypeAs.BUILDER.apply(type))).withName("builder")).addToModifiers(new Modifier[]{Modifier.PRIVATE})).addToModifiers(new Modifier[]{Modifier.FINAL})).build();
        EditableJavaProperty functionProperty = ((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)((JavaPropertyBuilder)new JavaPropertyBuilder().withType(functionType)).withName("function")).addToModifiers(new Modifier[]{Modifier.PRIVATE})).addToModifiers(new Modifier[]{Modifier.FINAL})).build();
        if (returnType.equals((Object)Constants.BOXED_VOID)) {
            returnType = clazz.getType();
        }
        JavaType baseInterface = TypeUtils.typeGenericOf((JavaType)BuilderUtils.getInlineType(ctx, inline), (JavaType[])new JavaType[]{returnType});
        JavaType fluentImpl = (JavaType)TypeAs.FLUENT_IMPL.apply(clazz.getType());
        JavaType fluentInterface = (JavaType)TypeAs.FLUENT_INTERFACE.apply(clazz.getType());
        EditableJavaType shallowInlineType = ((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder(inlineableType).withClassName(inline.prefix() + inlineableType.getClassName() + inline.suffix())).addToInterfaces(new JavaType[]{baseInterface})).build();
        EditableJavaType inlineType = ((JavaTypeBuilder)((JavaTypeBuilder)new JavaTypeBuilder((JavaType)shallowInlineType).withSuperClass(TypeUtils.typeGenericOf((JavaType)fluentImpl, (JavaType[])new JavaType[]{shallowInlineType}))).addToInterfaces(new JavaType[]{TypeUtils.typeGenericOf((JavaType)fluentInterface, (JavaType[])new JavaType[]{shallowInlineType})})).build();
        EditableJavaMethod inlineMethod = ((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType(returnType)).withName(inline.value())).addToAttributes("BODY", (Object)" return function.apply(builder.build());")).addToModifiers(new Modifier[]{Modifier.PUBLIC})).build();
        constructors.add(((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType((JavaType)inlineType)).withName("")).addNewArgument().withName("function")).withType(functionType)).and()).addToModifiers(new Modifier[]{Modifier.PUBLIC})).addToAttributes("BODY", (Object)("this.builder=new " + builderType.getSimpleName() + "(this);this.function=function;"))).build());
        constructors.add(((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType((JavaType)inlineType)).withName("")).addNewArgument().withName("item")).withType(type)).and()).addNewArgument().withName("function")).withType(functionType)).and()).addToModifiers(new Modifier[]{Modifier.PUBLIC})).addToAttributes("BODY", (Object)("this.builder=new " + builderType.getSimpleName() + "(this, item);this.function=function;"))).build());
        if (clazz.getType().equals((Object)returnType)) {
            constructors.add(((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType((JavaType)inlineType)).withName("")).addNewArgument().withName("function")).withType(functionType)).and()).addToModifiers(new Modifier[]{Modifier.PUBLIC})).addToAttributes("BODY", (Object)("this.builder=new " + builderType.getSimpleName() + "(this);this.function=new " + String.format(EMPTY_FUNCTION_TEXT, type.getSimpleName(), type.getSimpleName(), type.getSimpleName(), type.getSimpleName()) + ";"))).build());
            constructors.add(((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodBuilder)((JavaMethodFluent.ArgumentsNested)((JavaMethodFluent.ArgumentsNested)((JavaMethodBuilder)((JavaMethodBuilder)new JavaMethodBuilder().withReturnType((JavaType)inlineType)).withName("")).addNewArgument().withName("item")).withType(type)).and()).addToModifiers(new Modifier[]{Modifier.PUBLIC})).addToAttributes("BODY", (Object)("this.builder=new " + builderType.getSimpleName() + "(this, item);this.function=new " + String.format(EMPTY_FUNCTION_TEXT, type.getSimpleName(), type.getSimpleName(), type.getSimpleName(), type.getSimpleName()) + ";"))).build());
        }
        return ((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzBuilder)((JavaClazzBuilder)new JavaClazzBuilder().withType((JavaType)inlineType)).withConstructors(constructors)).addToFields(new JavaProperty[]{builderProperty, functionProperty})).addToMethods(new JavaMethod[]{inlineMethod})).build();
    }
}

