/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.readers.parameter;

import java.util.Optional;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import springfox.documentation.service.ResolvedMethodParameter;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.ParameterBuilderPlugin;
import springfox.documentation.spi.service.contexts.ParameterContext;

@Component
@Order(value=-2147483648)
public class ParameterNameReader
implements ParameterBuilderPlugin {
    public void apply(ParameterContext context) {
        String name = this.findParameterNameFromAnnotations(context.resolvedMethodParameter());
        if (StringUtils.isEmpty((Object)name)) {
            Optional discoveredName = context.resolvedMethodParameter().defaultName();
            name = discoveredName.orElseGet(() -> String.format("param%s", context.resolvedMethodParameter().getParameterIndex()));
        }
        context.parameterBuilder().name(name).description(name);
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private String findParameterNameFromAnnotations(ResolvedMethodParameter methodParameter) {
        return methodParameter.findAnnotation(PathVariable.class).map(PathVariable::value).orElse(methodParameter.findAnnotation(ModelAttribute.class).map(ModelAttribute::value).orElse(methodParameter.findAnnotation(RequestParam.class).map(RequestParam::value).orElse(methodParameter.findAnnotation(RequestHeader.class).map(RequestHeader::value).orElse(methodParameter.findAnnotation(RequestPart.class).map(RequestPart::value).orElse(null)))));
    }
}

