/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.web.controller;

import io.spring.initializr.metadata.InitializrMetadataProvider;
import java.nio.charset.StandardCharsets;
import org.springframework.util.DigestUtils;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

public abstract class AbstractMetadataController {
    protected final InitializrMetadataProvider metadataProvider;
    private Boolean forceSsl;

    protected AbstractMetadataController(InitializrMetadataProvider metadataProvider) {
        this.metadataProvider = metadataProvider;
    }

    protected String generateAppUrl() {
        ServletUriComponentsBuilder builder = ServletUriComponentsBuilder.fromCurrentServletMapping();
        if (this.isForceSsl()) {
            builder.scheme("https");
        }
        return builder.build().toString();
    }

    protected String createUniqueId(String content) {
        StringBuilder builder = new StringBuilder();
        DigestUtils.appendMd5DigestAsHex((byte[])content.getBytes(StandardCharsets.UTF_8), (StringBuilder)builder);
        return builder.toString();
    }

    private boolean isForceSsl() {
        if (this.forceSsl == null) {
            this.forceSsl = this.metadataProvider.get().getConfiguration().getEnv().isForceSsl();
        }
        return this.forceSsl;
    }
}

