/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.io.text;

import io.spring.initializr.generator.io.template.TemplateRenderer;
import io.spring.initializr.generator.io.text.Section;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class BulletedSection<T>
implements Section {
    private final TemplateRenderer templateRenderer;
    private final String templateName;
    private final String itemName;
    private final List<T> items = new ArrayList<T>();

    public BulletedSection(TemplateRenderer templateRenderer, String templateName) {
        this(templateRenderer, templateName, "items");
    }

    public BulletedSection(TemplateRenderer templateRenderer, String templateName, String itemName) {
        this.templateRenderer = templateRenderer;
        this.templateName = templateName;
        this.itemName = itemName;
    }

    public BulletedSection<T> addItem(T item) {
        this.items.add(item);
        return this;
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public List<T> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public void write(PrintWriter writer) throws IOException {
        if (!this.isEmpty()) {
            HashMap<String, List<T>> model = new HashMap<String, List<T>>();
            model.put(this.itemName, this.items);
            writer.println(this.templateRenderer.render(this.templateName, model));
        }
    }
}

