/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.io;

import java.util.function.Function;
import org.springframework.util.Assert;

public class SimpleIndentStrategy
implements Function<Integer, String> {
    private final String indent;

    public SimpleIndentStrategy(String indent) {
        Assert.notNull((Object)indent, (String)"Indent must be provided");
        this.indent = indent;
    }

    @Override
    public String apply(Integer level) {
        if (level < 0) {
            throw new IllegalArgumentException("Indent level must not be negative, got" + level);
        }
        return String.valueOf(this.indent).repeat(level);
    }
}

