/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.condition;

import io.spring.initializr.generator.buildsystem.BuildSystem;
import io.spring.initializr.generator.condition.ConditionalOnBuildSystem;
import io.spring.initializr.generator.condition.ProjectGenerationCondition;
import io.spring.initializr.generator.project.ProjectDescription;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;

class OnBuildSystemCondition
extends ProjectGenerationCondition {
    OnBuildSystemCondition() {
    }

    @Override
    protected boolean matches(ProjectDescription description, ConditionContext context, AnnotatedTypeMetadata metadata) {
        MultiValueMap attributes = metadata.getAllAnnotationAttributes(ConditionalOnBuildSystem.class.getName());
        String buildSystemId = (String)attributes.getFirst((Object)"value");
        String dialect = (String)attributes.getFirst((Object)"dialect");
        BuildSystem buildSystem = description.getBuildSystem();
        if (buildSystem.id().equals(buildSystemId)) {
            if (StringUtils.hasText((String)dialect)) {
                return dialect.equals(buildSystem.dialect());
            }
            return true;
        }
        return false;
    }
}

