/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code.kotlin;

import io.spring.initializr.generator.condition.ConditionalOnBuildSystem;
import io.spring.initializr.generator.condition.ConditionalOnLanguage;
import io.spring.initializr.generator.io.IndentingWriterFactory;
import io.spring.initializr.generator.language.SourceCodeWriter;
import io.spring.initializr.generator.language.kotlin.KotlinCompilationUnit;
import io.spring.initializr.generator.language.kotlin.KotlinSourceCode;
import io.spring.initializr.generator.language.kotlin.KotlinSourceCodeWriter;
import io.spring.initializr.generator.language.kotlin.KotlinTypeDeclaration;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.ProjectGenerationConfiguration;
import io.spring.initializr.generator.spring.code.MainApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.MainCompilationUnitCustomizer;
import io.spring.initializr.generator.spring.code.MainSourceCodeCustomizer;
import io.spring.initializr.generator.spring.code.MainSourceCodeProjectContributor;
import io.spring.initializr.generator.spring.code.TestApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.TestSourceCodeCustomizer;
import io.spring.initializr.generator.spring.code.TestSourceCodeProjectContributor;
import io.spring.initializr.generator.spring.code.kotlin.InitializrMetadataKotlinVersionResolver;
import io.spring.initializr.generator.spring.code.kotlin.KotlinJacksonBuildCustomizer;
import io.spring.initializr.generator.spring.code.kotlin.KotlinProjectGenerationDefaultContributorsConfiguration;
import io.spring.initializr.generator.spring.code.kotlin.KotlinProjectSettings;
import io.spring.initializr.generator.spring.code.kotlin.KotlinVersionResolver;
import io.spring.initializr.generator.spring.code.kotlin.SimpleKotlinProjectSettings;
import io.spring.initializr.generator.spring.scm.git.GitIgnore;
import io.spring.initializr.generator.spring.scm.git.GitIgnoreCustomizer;
import io.spring.initializr.metadata.InitializrMetadata;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;

@ProjectGenerationConfiguration
@ConditionalOnLanguage(value="kotlin")
@Import(value={KotlinProjectGenerationDefaultContributorsConfiguration.class})
public class KotlinProjectGenerationConfiguration {
    private final ProjectDescription description;
    private final IndentingWriterFactory indentingWriterFactory;

    public KotlinProjectGenerationConfiguration(ProjectDescription description, IndentingWriterFactory indentingWriterFactory) {
        this.description = description;
        this.indentingWriterFactory = indentingWriterFactory;
    }

    @Bean
    public MainSourceCodeProjectContributor<KotlinTypeDeclaration, KotlinCompilationUnit, KotlinSourceCode> mainKotlinSourceCodeProjectContributor(ObjectProvider<MainApplicationTypeCustomizer<?>> mainApplicationTypeCustomizers, ObjectProvider<MainCompilationUnitCustomizer<?, ?>> mainCompilationUnitCustomizers, ObjectProvider<MainSourceCodeCustomizer<?, ?, ?>> mainSourceCodeCustomizers) {
        return new MainSourceCodeProjectContributor<KotlinTypeDeclaration, KotlinCompilationUnit, KotlinSourceCode>(this.description, KotlinSourceCode::new, (SourceCodeWriter<KotlinSourceCode>)new KotlinSourceCodeWriter(this.indentingWriterFactory), mainApplicationTypeCustomizers, mainCompilationUnitCustomizers, mainSourceCodeCustomizers);
    }

    @Bean
    public TestSourceCodeProjectContributor<KotlinTypeDeclaration, KotlinCompilationUnit, KotlinSourceCode> testKotlinSourceCodeProjectContributor(ObjectProvider<TestApplicationTypeCustomizer<?>> testApplicationTypeCustomizers, ObjectProvider<TestSourceCodeCustomizer<?, ?, ?>> testSourceCodeCustomizers) {
        return new TestSourceCodeProjectContributor<KotlinTypeDeclaration, KotlinCompilationUnit, KotlinSourceCode>(this.description, KotlinSourceCode::new, (SourceCodeWriter<KotlinSourceCode>)new KotlinSourceCodeWriter(this.indentingWriterFactory), testApplicationTypeCustomizers, testSourceCodeCustomizers);
    }

    @Bean
    @ConditionalOnBuildSystem(value="gradle")
    public GitIgnoreCustomizer kotlinGradlePluginGitIgnoreCustomizer() {
        return gitIgnore -> {
            GitIgnore.GitIgnoreSection section = gitIgnore.addSectionIfAbsent("Kotlin");
            section.add(".kotlin");
        };
    }

    @Bean
    public KotlinProjectSettings kotlinProjectSettings(ObjectProvider<KotlinVersionResolver> kotlinVersionResolver, InitializrMetadata metadata) {
        String kotlinVersion = ((KotlinVersionResolver)kotlinVersionResolver.getIfAvailable(() -> new InitializrMetadataKotlinVersionResolver(metadata))).resolveKotlinVersion(this.description);
        return new SimpleKotlinProjectSettings(kotlinVersion, this.description.getLanguage().jvmVersion());
    }

    @Bean
    public KotlinJacksonBuildCustomizer kotlinJacksonBuildCustomizer(InitializrMetadata metadata) {
        return new KotlinJacksonBuildCustomizer(metadata, this.description);
    }
}

