/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.code;

import io.spring.initializr.generator.language.CompilationUnit;
import io.spring.initializr.generator.language.SourceCode;
import io.spring.initializr.generator.language.SourceCodeWriter;
import io.spring.initializr.generator.language.TypeDeclaration;
import io.spring.initializr.generator.project.ProjectDescription;
import io.spring.initializr.generator.project.contributor.ProjectContributor;
import io.spring.initializr.generator.spring.code.MainApplicationTypeCustomizer;
import io.spring.initializr.generator.spring.code.MainCompilationUnitCustomizer;
import io.spring.initializr.generator.spring.code.MainSourceCodeCustomizer;
import io.spring.initializr.generator.spring.util.LambdaSafe;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;

public class MainSourceCodeProjectContributor<T extends TypeDeclaration, C extends CompilationUnit<T>, S extends SourceCode<T, C>>
implements ProjectContributor {
    private final ProjectDescription description;
    private final Supplier<S> sourceFactory;
    private final SourceCodeWriter<S> sourceWriter;
    private final ObjectProvider<MainApplicationTypeCustomizer<? extends TypeDeclaration>> mainTypeCustomizers;
    private final ObjectProvider<MainCompilationUnitCustomizer<?, ?>> mainCompilationUnitCustomizers;
    private final ObjectProvider<MainSourceCodeCustomizer<?, ?, ?>> mainSourceCodeCustomizers;

    public MainSourceCodeProjectContributor(ProjectDescription description, Supplier<S> sourceFactory, SourceCodeWriter<S> sourceWriter, ObjectProvider<MainApplicationTypeCustomizer<?>> mainTypeCustomizers, ObjectProvider<MainCompilationUnitCustomizer<?, ?>> mainCompilationUnitCustomizers, ObjectProvider<MainSourceCodeCustomizer<?, ?, ?>> mainSourceCodeCustomizers) {
        this.description = description;
        this.sourceFactory = sourceFactory;
        this.sourceWriter = sourceWriter;
        this.mainTypeCustomizers = mainTypeCustomizers;
        this.mainCompilationUnitCustomizers = mainCompilationUnitCustomizers;
        this.mainSourceCodeCustomizers = mainSourceCodeCustomizers;
    }

    public void contribute(Path projectRoot) throws IOException {
        SourceCode sourceCode = (SourceCode)this.sourceFactory.get();
        String applicationName = this.description.getApplicationName();
        CompilationUnit compilationUnit = sourceCode.createCompilationUnit(this.description.getPackageName(), applicationName);
        TypeDeclaration mainApplicationType = compilationUnit.createTypeDeclaration(applicationName);
        this.customizeMainApplicationType(mainApplicationType);
        this.customizeMainCompilationUnit(compilationUnit);
        this.customizeMainSourceCode(sourceCode);
        this.sourceWriter.writeTo(this.description.getBuildSystem().getMainSource(projectRoot, this.description.getLanguage()), sourceCode);
    }

    private void customizeMainApplicationType(T mainApplicationType) {
        List customizers = this.mainTypeCustomizers.orderedStream().collect(Collectors.toList());
        LambdaSafe.callbacks(MainApplicationTypeCustomizer.class, customizers, mainApplicationType, new Object[0]).invoke(customizer -> customizer.customize(mainApplicationType));
    }

    private void customizeMainCompilationUnit(C compilationUnit) {
        List customizers = this.mainCompilationUnitCustomizers.orderedStream().collect(Collectors.toList());
        LambdaSafe.callbacks(MainCompilationUnitCustomizer.class, customizers, compilationUnit, new Object[0]).invoke(customizer -> customizer.customize(compilationUnit));
    }

    private void customizeMainSourceCode(S sourceCode) {
        List customizers = this.mainSourceCodeCustomizers.orderedStream().collect(Collectors.toList());
        LambdaSafe.callbacks(MainSourceCodeCustomizer.class, customizers, sourceCode, new Object[0]).invoke(customizer -> customizer.customize(sourceCode));
    }
}

