/*
 * Decompiled with CFR 0.152.
 */
package io.spring.initializr.generator.spring.build;

import io.spring.initializr.generator.buildsystem.Build;
import java.util.function.Consumer;
import org.springframework.core.Ordered;

@FunctionalInterface
public interface BuildCustomizer<B extends Build>
extends Ordered {
    public void customize(B var1);

    default public int getOrder() {
        return 0;
    }

    public static <B extends Build> BuildCustomizer<B> ordered(int order, Consumer<B> customizer) {
        return new OrderedBuildCustomizer<B>(order, customizer);
    }

    public static class OrderedBuildCustomizer<B extends Build>
    implements BuildCustomizer<B> {
        private final int order;
        private final Consumer<B> customizer;

        public OrderedBuildCustomizer(int order, Consumer<B> customizer) {
            this.order = order;
            this.customizer = customizer;
        }

        @Override
        public void customize(B build) {
            this.customizer.accept(build);
        }

        @Override
        public int getOrder() {
            return this.order;
        }
    }
}

