/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.groups;

import io.smallrye.mutiny.Context;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.helpers.UniCallbackSubscriber;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.uni.UniSubscribeToCompletionStage;
import io.smallrye.mutiny.subscription.Cancellable;
import io.smallrye.mutiny.subscription.UniSerializedSubscriber;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class UniSubscribe<T> {
    private final AbstractUni<T> upstream;

    public UniSubscribe(AbstractUni<T> upstream) {
        this.upstream = ParameterValidation.nonNull(upstream, "upstream");
    }

    public <S extends UniSubscriber<? super T>> S withSubscriber(S subscriber) {
        AbstractUni.subscribe(this.upstream, ParameterValidation.nonNull(subscriber, "subscriber"));
        return subscriber;
    }

    public <S extends UniSubscriber<? super T>> S withSerializedSubscriber(S subscriber) {
        UniSerializedSubscriber.subscribe(this.upstream, ParameterValidation.nonNull(subscriber, "subscriber"));
        return subscriber;
    }

    public Cancellable with(Consumer<? super T> onItemCallback, Consumer<? super Throwable> onFailureCallback) {
        return this.with(Context.empty(), onItemCallback, onFailureCallback);
    }

    public Cancellable with(Context context, Consumer<? super T> onItemCallback, Consumer<? super Throwable> onFailureCallback) {
        UniCallbackSubscriber<? super T> subscriber = new UniCallbackSubscriber<T>(Infrastructure.decorate(ParameterValidation.nonNull(onItemCallback, "onItemCallback")), Infrastructure.decorate(ParameterValidation.nonNull(onFailureCallback, "onFailureCallback")), ParameterValidation.nonNull(context, "context"));
        this.withSubscriber(subscriber);
        return subscriber;
    }

    public Cancellable with(Context context, Consumer<? super T> onItemCallback) {
        UniCallbackSubscriber<? super T> subscriber = new UniCallbackSubscriber<T>(Infrastructure.decorate(ParameterValidation.nonNull(onItemCallback, "onItemCallback")), Infrastructure::handleDroppedException, ParameterValidation.nonNull(context, "context"));
        this.withSubscriber(subscriber);
        return subscriber;
    }

    public Cancellable with(Consumer<? super T> onItemCallback) {
        return this.with(Context.empty(), onItemCallback);
    }

    public CompletableFuture<T> asCompletionStage() {
        return this.asCompletionStage(Context.empty());
    }

    public CompletableFuture<T> asCompletionStage(Context context) {
        return UniSubscribeToCompletionStage.subscribe(this.upstream, context);
    }
}

