/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Enumeration;
import java.util.Scanner;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Utils {
    private static final Logger log = LogManager.getLogger(Utils.class);
    private static final int MAX_HTTP_TRIES = 60;

    public static void shutdownLog(Logger log, InterruptedException ie) {
        log.info("Execution interrupted, exiting.");
        if (log.isTraceEnabled()) {
            log.trace("Interrupted from: ", (Throwable)ie);
        }
    }

    public static boolean waitForHttp(String urlString, int code) throws Exception {
        URL url = new URL(urlString);
        int lastCode = -1;
        for (int i = 0; i < 60; ++i) {
            try {
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.connect();
                lastCode = conn.getResponseCode();
                if (lastCode == code) {
                    conn.disconnect();
                    return true;
                }
                conn.disconnect();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            Thread.sleep(1000L);
        }
        return false;
    }

    public static String readFromUrl(String urlString) throws IOException {
        return new Scanner(new URL(urlString).openStream(), "UTF-8").useDelimiter("\\A").next();
    }

    public static String getManifestEntry(Class clazz, String entryName) throws IOException {
        Enumeration<URL> resources = clazz.getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (resources.hasMoreElements()) {
            InputStream is = resources.nextElement().openStream();
            Throwable throwable = null;
            try {
                Manifest manifest = new Manifest(is);
                Attributes attr = manifest.getMainAttributes();
                String value = attr.getValue(entryName);
                if (value == null || value.length() <= 0) continue;
                String string = value;
                return string;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (is == null) continue;
                if (throwable != null) {
                    try {
                        is.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                is.close();
            }
        }
        return null;
    }

    public static String getClassImplVersion(Class clazz) {
        try {
            return Utils.getManifestEntry(clazz, "Implementation-Version");
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot obtain version for class {}.", new Object[]{clazz.getName()});
            }
            return null;
        }
    }

    public static String getClassSpecVersion(Class clazz) {
        try {
            return Utils.getManifestEntry(clazz, "Specification-Version");
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug("Cannot obtain version for class {}.", new Object[]{clazz.getName()});
            }
            return null;
        }
    }

    public static void sleep(long ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

