/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices.util;

import io.silverware.microservices.Context;
import io.silverware.microservices.providers.MicroserviceProvider;
import io.silverware.microservices.util.ClassLoaderUtil;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.scanners.ResourcesScanner;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.SubTypesScanner;
import org.reflections.util.ClasspathHelper;
import org.reflections.util.ConfigurationBuilder;
import org.reflections.vfs.SystemDir;
import org.reflections.vfs.Vfs;
import org.reflections.vfs.ZipDir;

public class DeploymentScanner {
    private static final Logger log = LogManager.getLogger(DeploymentScanner.class);
    private static DeploymentScanner defaultScanner = null;
    private final Reflections reflections;

    private DeploymentScanner() {
        ConfigurationBuilder builder = ConfigurationBuilder.build((Object[])new Object[]{""});
        DeploymentScanner.addNestedClasspathUrls(builder);
        DeploymentScanner.removeSysLibUrls(builder);
        builder.addScanners(new Scanner[]{new ResourcesScanner()});
        this.reflections = new Reflections((Configuration)builder);
    }

    private DeploymentScanner(String ... packages) {
        ConfigurationBuilder builder = ConfigurationBuilder.build((Object[])packages);
        DeploymentScanner.removeSysLibUrls(builder);
        builder.addScanners(new Scanner[]{new ResourcesScanner()});
        this.reflections = new Reflections((Configuration)builder);
    }

    public static synchronized DeploymentScanner getDefaultInstance() {
        if (defaultScanner == null) {
            defaultScanner = new DeploymentScanner();
        }
        return defaultScanner;
    }

    public static DeploymentScanner getInstance(String ... packages) {
        return new DeploymentScanner(packages);
    }

    public static DeploymentScanner getContextInstance(Context context) {
        String packages = (String)context.getProperties().get("silverware.deploy.packages");
        if (packages != null) {
            if (log.isDebugEnabled()) {
                log.debug("Limited deployment packages: " + packages);
            }
            return DeploymentScanner.getInstance(packages.split("[ ]*,[ ]*"));
        }
        return DeploymentScanner.getDefaultInstance();
    }

    public Set<Class<? extends MicroserviceProvider>> lookupMicroserviceProviders() {
        return this.reflections.getSubTypesOf(MicroserviceProvider.class);
    }

    public Set lookupSubtypes(Class clazz) {
        return this.reflections.getSubTypesOf(clazz);
    }

    public Set<String> lookupResources(String pattern) {
        return this.reflections.getResources(Pattern.compile(pattern));
    }

    public static <T> List<T> instantiate(Set<Class<T>> classes) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException, InstantiationException {
        ArrayList<T> instances = new ArrayList<T>();
        for (Class<T> clazz : classes) {
            if (log.isDebugEnabled()) {
                log.debug("Creating instance of " + clazz.getName());
            }
            Constructor<T> c = clazz.getConstructor(new Class[0]);
            T t = c.newInstance(new Object[0]);
            instances.add(t);
        }
        return instances;
    }

    private static void addNestedClasspathUrls(ConfigurationBuilder builder) {
        ClassLoader[] cls = ClasspathHelper.classLoaders((ClassLoader[])builder.getClassLoaders());
        builder.addUrls(ClassLoaderUtil.getAlsoNestedClasspathUrls(Arrays.asList(cls)));
    }

    private static void removeSysLibUrls(ConfigurationBuilder builder) {
        Pattern sysLibPattern = Pattern.compile(".*[.](so|dll)", 2);
        Set urls = builder.getUrls().stream().filter(url -> !sysLibPattern.matcher(url.getFile()).matches()).collect(Collectors.toCollection(LinkedHashSet::new));
        builder.setUrls((Collection)urls);
    }

    static {
        Vfs.addDefaultURLTypes((Vfs.UrlType)new WarUrlType());
    }

    public static class TransitiveInterfacesScanner
    extends SubTypesScanner {
        public void scan(Object cls) {
            block4: {
                String className = this.getMetadataAdapter().getClassName(cls);
                try {
                    Class<?> clazz = Class.forName(className);
                    while (!(clazz.getCanonicalName().startsWith("javax.") || clazz.getCanonicalName().startsWith("java.") || clazz.getCanonicalName().startsWith("com.sun.") || clazz.getCanonicalName().startsWith("sun."))) {
                        for (Class<?> anInterface : clazz.getInterfaces()) {
                            if (!this.acceptResult(anInterface.getCanonicalName())) continue;
                            this.getStore().put((Object)anInterface.getCanonicalName(), (Object)className);
                        }
                        clazz = clazz.getSuperclass();
                    }
                }
                catch (Throwable ex) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace("Could not load class {}", new Object[]{className});
                }
            }
        }
    }

    public static class WarUrlType
    implements Vfs.UrlType {
        public boolean matches(URL url) {
            return url.getProtocol().equals("file") && url.toExternalForm().endsWith(".war");
        }

        public Vfs.Dir createDir(URL url) throws IOException, URISyntaxException {
            File file = new File(url.toURI());
            if (file.isDirectory()) {
                return new SystemDir(file);
            }
            return new ZipDir(new JarFile(file));
        }
    }
}

