/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices.util;

import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ClassLoaderUtil {
    private static final Logger log = LogManager.getLogger(ClassLoaderUtil.class);

    private ClassLoaderUtil() {
    }

    public static Set<URL> getAlsoNestedClasspathUrls(List<ClassLoader> basicClassLoaders) {
        if (basicClassLoaders == null || basicClassLoaders.isEmpty()) {
            return Collections.emptySet();
        }
        Set<ClassLoader> classLoaders = ClassLoaderUtil.getAlsoParentsClassLoaders(basicClassLoaders);
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        for (ClassLoader cl : classLoaders) {
            try {
                result.addAll(ClassLoaderUtil.getAlsoNestedClasspathUrls(cl));
            }
            catch (IOException ioe) {
                log.warn("Unable to investigate nested classpath of {}: {}", new Object[]{cl, ioe});
            }
        }
        return result;
    }

    private static Set<URL> getAlsoNestedClasspathUrls(ClassLoader cl) throws IOException {
        URL[] urls;
        LinkedHashSet<URL> result = new LinkedHashSet<URL>();
        if (cl instanceof URLClassLoader && (urls = ((URLClassLoader)cl).getURLs()) != null && urls.length > 0) {
            result.addAll(Arrays.asList(urls));
        }
        Enumeration<URL> eResource = cl.getResources("META-INF");
        while (eResource.hasMoreElements()) {
            URL jarFileUrl;
            URL urlResource = eResource.nextElement();
            URLConnection connection = urlResource.openConnection();
            if (!(connection instanceof JarURLConnection) || result.contains(jarFileUrl = ((JarURLConnection)connection).getJarFileURL())) continue;
            log.debug("Got nested classpath url " + jarFileUrl);
            result.add(jarFileUrl);
        }
        return result;
    }

    private static Set<ClassLoader> getAlsoParentsClassLoaders(List<ClassLoader> basicClassLoaders) {
        LinkedHashSet<ClassLoader> result = new LinkedHashSet<ClassLoader>(basicClassLoaders);
        for (ClassLoader basicClassLoader : basicClassLoaders) {
            for (ClassLoader parent = basicClassLoader.getParent(); parent != null; parent = parent.getParent()) {
                result.add(parent);
            }
        }
        return result;
    }
}

