/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices.silver.services;

import io.silverware.microservices.Context;
import io.silverware.microservices.MicroserviceMetaData;
import io.silverware.microservices.annotations.InvocationPolicy;
import io.silverware.microservices.silver.services.LookupStrategy;
import io.silverware.microservices.silver.services.lookup.LocalLookupStrategy;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LookupStrategyFactory {
    private static Logger log = LogManager.getLogger(LookupStrategyFactory.class);

    public static LookupStrategy getStrategy(Context context, MicroserviceMetaData metaData, Set<Annotation> options) {
        LookupStrategy strategy = null;
        for (Annotation option : options) {
            if (!option.annotationType().isAssignableFrom(InvocationPolicy.class)) continue;
            InvocationPolicy policy = (InvocationPolicy)option;
            Class<? extends LookupStrategy> clazz = policy.lookupStrategy();
            try {
                Constructor<? extends LookupStrategy> c = clazz.getConstructor(new Class[0]);
                strategy = c.newInstance(new Object[0]);
                strategy.initialize(context, metaData, options);
                break;
            }
            catch (Exception e) {
                log.warn(String.format("Could not instantiate lookup strategy class %s:", clazz.getName()), (Throwable)e);
            }
        }
        if (strategy == null) {
            strategy = new LocalLookupStrategy();
            strategy.initialize(context, metaData, options);
        }
        return strategy;
    }
}

