/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices.silver.cluster;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import io.silverware.microservices.Context;
import io.silverware.microservices.MicroserviceMetaData;
import io.silverware.microservices.silver.cluster.Invocation;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;

public class ServiceHandle
implements Serializable {
    private static final transient AtomicInteger handleSource = new AtomicInteger(0);
    private final int handle = handleSource.getAndIncrement();
    private final String host;
    private final MicroserviceMetaData query;
    private final transient Object service;

    public ServiceHandle(String host, MicroserviceMetaData query, Object service) {
        this.host = host;
        this.query = query;
        this.service = service;
    }

    public ServiceHandle withProxy(Object proxy) {
        return new ServiceHandle(this.host, this.query, proxy);
    }

    public int getHandle() {
        return this.handle;
    }

    public String getHost() {
        return this.host;
    }

    public MicroserviceMetaData getQuery() {
        return this.query;
    }

    public Object getService() {
        return this.service;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceHandle that = (ServiceHandle)o;
        if (this.handle != that.handle) {
            return false;
        }
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        return this.query.equals(that.query);
    }

    public int hashCode() {
        int result = this.handle;
        result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
        result = 31 * result + this.query.hashCode();
        return result;
    }

    public String toString() {
        return "ServiceHandle{handle=" + this.handle + ", host='" + this.host + '\'' + ", query=" + this.query + ", service=" + this.service + '}';
    }

    public Object invoke(Context context, String method, Class[] paramTypes, Object[] params) throws Exception {
        String urlBase = "http://" + this.host + "/" + context.getProperties().get("silverware.http-invoker.url") + "/invoke";
        HttpURLConnection con = (HttpURLConnection)new URL(urlBase).openConnection();
        con.setRequestMethod("POST");
        con.setDoInput(true);
        con.setDoOutput(true);
        con.connect();
        Invocation invocation = new Invocation(this.handle, method, paramTypes, params);
        JsonWriter jsonWriter = new JsonWriter(con.getOutputStream());
        jsonWriter.write((Object)invocation);
        JsonReader jsonReader = new JsonReader(con.getInputStream());
        Object response = jsonReader.readObject();
        con.disconnect();
        return response;
    }

    public Object invoke(Context context, String method, Object[] params) throws Exception {
        Class[] paramTypes = new Class[params.length];
        for (int i = 0; i < params.length; ++i) {
            paramTypes[i] = params.getClass();
        }
        return this.invoke(context, method, paramTypes, params);
    }
}

