/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices;

import com.cedarsoftware.util.io.JsonReader;
import com.cedarsoftware.util.io.JsonWriter;
import io.silverware.microservices.Context;
import io.silverware.microservices.silver.cluster.ServiceHandle;
import io.silverware.microservices.util.Utils;
import java.lang.annotation.Annotation;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class MicroserviceMetaData {
    private final String name;
    private final Class type;
    private final Set<Annotation> qualifiers;
    private final Set<Annotation> annotations;
    private final String specVersion;
    private final String implVersion;

    public MicroserviceMetaData(String name, Class type, Set<Annotation> qualifiers, Set<Annotation> annotations) {
        this.name = name;
        this.type = type;
        this.qualifiers = qualifiers;
        this.annotations = annotations;
        this.specVersion = Utils.getClassSpecVersion(type);
        this.implVersion = Utils.getClassImplVersion(type);
        if (name == null || type == null) {
            throw new IllegalStateException("Name and type fields cannot be null.");
        }
    }

    public MicroserviceMetaData(String name, Class type, Set<Annotation> qualifiers) {
        this.name = name;
        this.type = type;
        this.qualifiers = qualifiers;
        this.annotations = new HashSet<Annotation>();
        this.specVersion = Utils.getClassSpecVersion(type);
        this.implVersion = Utils.getClassImplVersion(type);
        if (name == null || type == null) {
            throw new IllegalStateException("Name and type fields cannot be null.");
        }
    }

    public MicroserviceMetaData(String name, Class type, Set<Annotation> qualifiers, Set<Annotation> annotations, String specVersion, String implVersion) {
        this.name = name;
        this.type = type;
        this.qualifiers = qualifiers;
        this.annotations = annotations;
        this.specVersion = specVersion;
        this.implVersion = implVersion;
        if (name == null || type == null) {
            throw new IllegalStateException("Name and type fields cannot be null.");
        }
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        return this.type;
    }

    public Set<Annotation> getQualifiers() {
        return this.qualifiers;
    }

    public Set<Annotation> getAnnotations() {
        return this.annotations;
    }

    public String getSpecVersion() {
        return this.specVersion;
    }

    public String getImplVersion() {
        return this.implVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MicroserviceMetaData that = (MicroserviceMetaData)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.type.equals(that.type)) {
            return false;
        }
        if (this.qualifiers != null ? !this.qualifiers.equals(that.qualifiers) : that.qualifiers != null) {
            return false;
        }
        if (this.annotations != null ? !this.annotations.equals(that.annotations) : that.annotations != null) {
            return false;
        }
        return !(this.specVersion == null ? that.specVersion != null : !this.specVersion.equals(that.specVersion));
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.type.hashCode();
        result = 31 * result + (this.qualifiers != null ? this.qualifiers.hashCode() : 0);
        result = 31 * result + (this.annotations != null ? this.annotations.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "microservice " + this.name + " of type " + this.type.getCanonicalName() + " with qualifiers " + Arrays.toString(this.qualifiers.toArray()) + " and with annotations " + Arrays.toString(this.annotations.toArray()) + " (version: spec. " + this.specVersion + ", impl. " + this.implVersion + ")";
    }

    public List<ServiceHandle> query(Context context, String host) throws Exception {
        String urlBase = "http://" + host + "/" + context.getProperties().get("silverware.http-invoker.url") + "/query";
        HttpURLConnection con = (HttpURLConnection)new URL(urlBase).openConnection();
        con.setRequestMethod("POST");
        con.setDoInput(true);
        con.setDoOutput(true);
        con.connect();
        JsonWriter jsonWriter = new JsonWriter(con.getOutputStream());
        jsonWriter.write((Object)this);
        JsonReader jsonReader = new JsonReader(con.getInputStream());
        List response = (List)jsonReader.readObject();
        con.disconnect();
        return response;
    }
}

