/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices;

import io.silverware.microservices.Context;
import io.silverware.microservices.MicroserviceMetaData;
import io.silverware.microservices.providers.MicroserviceProvider;
import io.silverware.microservices.silver.ProvidingSilverService;
import io.silverware.microservices.util.DeployStats;
import io.silverware.microservices.util.DeploymentScanner;
import io.silverware.microservices.util.Utils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Executor
implements MicroserviceProvider,
ProvidingSilverService {
    public static final String THREAD_PREFIX = "SilverWare-";
    public static final String BOOT_THREAD = "boot";
    public static final String MAIN_THREAD = "main";
    public static final String SHUTDOWN_HOOK = "silverware.shutdown";
    private static final Logger log = LogManager.getLogger(Executor.class);
    private final List<MicroserviceProvider> instances = new ArrayList<MicroserviceProvider>();
    private final ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newCachedThreadPool(new DaemonThreadFactory());
    private final DeployStats stats = new DeployStats();
    private Context context = null;
    private Thread shutdownHook;

    public static void bootHook() throws InterruptedException {
        Context context = new Context();
        Executor.bootHook(context);
    }

    public static void bootHook(Context initialContext) throws InterruptedException {
        Executor executor = new Executor();
        executor.initialize(initialContext);
        executor.boot();
    }

    private void boot() throws InterruptedException {
        block4: {
            Thread bootThread = new Thread(this);
            bootThread.setName("SilverWare-boot");
            bootThread.start();
            try {
                bootThread.join();
            }
            catch (InterruptedException ie) {
                if (this.shutdownHook == null) break block4;
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
                Thread shutdownThread = new Thread(this.shutdownHook);
                shutdownThread.start();
                try {
                    shutdownThread.join();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void createInstances(Set<Class<? extends MicroserviceProvider>> microserviceProviders) {
        log.info(String.format("Found %d microservice providers. Starting...", microserviceProviders.size()));
        this.stats.setFound(microserviceProviders.size());
        for (Class<? extends MicroserviceProvider> clazz : microserviceProviders) {
            if (log.isDebugEnabled()) {
                log.debug("Creating microservice provider: " + clazz.getName());
            }
            if (clazz.getName().equals(this.getClass().getName())) {
                if (log.isDebugEnabled()) {
                    log.debug("Skipping myself (Executor microservice provider) as I am already running.");
                }
                this.stats.incSkipped();
                continue;
            }
            try {
                Constructor<? extends MicroserviceProvider> c = clazz.getConstructor(new Class[0]);
                MicroserviceProvider m = c.newInstance(new Object[0]);
                m.initialize(this.context);
                this.instances.add(m);
                this.stats.incDeployed();
                this.context.getProvidersRegistry().put(m.getClass().getName(), m);
            }
            catch (Error | Exception e) {
                log.warn(String.format("Unable to start microservice provider: %s", clazz.getName()), e);
            }
        }
    }

    private void startInstances() {
        log.info("Running microservice providers...");
        for (MicroserviceProvider m : this.instances) {
            if (log.isDebugEnabled()) {
                log.debug("Running microservice provider: " + m.getClass().getName());
            }
            this.executor.submit(m);
        }
        log.info("Total microservice providers " + this.stats.toString() + ".");
        this.executor.shutdown();
    }

    @Override
    public void initialize(Context context) {
        this.context = context;
        context.getProvidersRegistry().put(this.getClass().getName(), this);
        if (Boolean.parseBoolean((String)context.getProperties().getOrDefault(SHUTDOWN_HOOK, "true"))) {
            this.shutdownHook = new Thread(new ShutdownHook(this.executor));
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    @Override
    public void run() {
        log.info("Looking up microservice providers...");
        this.createInstances(DeploymentScanner.getContextInstance(this.context).lookupMicroserviceProviders());
        this.startInstances();
        try {
            int active;
            boolean firstTime = true;
            do {
                active = this.executor.getActiveCount();
                if (firstTime) {
                    log.info("Microservice providers alive: " + active);
                    firstTime = false;
                } else if (log.isDebugEnabled()) {
                    log.debug("Still here ;-) Microservice providers alive: " + active);
                }
                if (active <= 0) continue;
                this.executor.awaitTermination(1L, TimeUnit.MINUTES);
            } while (active > 0);
            log.info("All work is done. Graceful termination.");
            if (this.shutdownHook != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
        }
        catch (InterruptedException ie) {
            Utils.shutdownLog(log, ie);
        }
    }

    @Override
    public Set<Object> lookupMicroservice(MicroserviceMetaData metaData) {
        HashSet<Object> providers = new HashSet<Object>();
        this.context.getAllProviders(metaData.getType()).forEach(providers::add);
        return providers;
    }

    @Override
    public Context getContext() {
        return this.context;
    }

    public class ShutdownHook
    implements Runnable {
        private final Logger log = LogManager.getLogger(ShutdownHook.class);
        private final ThreadPoolExecutor executor;

        public ShutdownHook(ThreadPoolExecutor executor) {
            this.executor = executor;
        }

        private void terminateThread(Thread thread) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("Terminating thread {}...", new Object[]{thread.getName()});
            }
            thread.interrupt();
            int tries = 0;
            while (thread.isAlive() && tries < 20) {
                ++tries;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {
                    this.log.warn("Cannot wait for thread termination: ", (Throwable)e);
                }
            }
            if (thread.isAlive()) {
                this.log.warn("Could not terminate thread {}.", new Object[]{thread.getName()});
            }
        }

        @Override
        public void run() {
            Executor.this.shutdownHook = null;
            this.log.info("Terminating SilverWare...");
            ThreadGroup group = ((DaemonThreadFactory)this.executor.getThreadFactory()).getGroup();
            Thread[] threadList = new Thread[group.activeCount() + 1];
            group.enumerate(threadList);
            Thread bootThread = null;
            Thread mainThread = null;
            for (int i = 0; i < threadList.length; ++i) {
                String threadName;
                if (threadList[i] == null || !(threadName = threadList[i].getName()).startsWith(Executor.THREAD_PREFIX)) continue;
                if (threadName.equals("SilverWare-main")) {
                    mainThread = threadList[i];
                    continue;
                }
                if (threadName.equals("SilverWare-boot")) {
                    bootThread = threadList[i];
                    continue;
                }
                this.terminateThread(threadList[i]);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Waiting for main thread cleanup.");
            }
            while (mainThread != null && mainThread.isAlive() || bootThread != null && bootThread.isAlive()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.log.warn((Object)e);
                }
            }
        }
    }

    static class DaemonThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger poolNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final String namePrefix;

        DaemonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = Executor.THREAD_PREFIX + poolNumber.getAndIncrement() + "-microservice-provider-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            t.setPriority(8);
            return t;
        }

        public ThreadGroup getGroup() {
            return this.group;
        }
    }
}

