/*
 * Decompiled with CFR 0.152.
 */
package io.silverware.microservices;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import io.silverware.microservices.Context;
import io.silverware.microservices.Executor;
import io.silverware.microservices.util.Utils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;

@SuppressWarnings(value={"DM_EXIT"}, justification="This class is allowed to terminate the JVM.")
public final class Boot {
    private static final Logger log = LogManager.getLogger(Boot.class);
    private static final String PROPERTY_LETTER = "D";
    private static final String PROPERTY_FILE_LETTER = "p";

    public static void main(String ... args) {
        Boot.preMainConfig();
        log.info("=== Welcome to SilverWare ===");
        try {
            Executor.bootHook(Boot.getInitialContext(args));
        }
        catch (InterruptedException ie) {
            Utils.shutdownLog(log, ie);
        }
        log.info("Goodbye.");
        Boot.logFlush();
    }

    private static void preMainConfig() {
        Thread.currentThread().setName("SilverWare-main");
    }

    private static void logFlush() {
        ((LoggerContext)LogManager.getContext()).stop();
    }

    private static Properties loadProperties() {
        Properties props = new Properties();
        try {
            props.load(Boot.class.getResourceAsStream("silverware.properties"));
        }
        catch (IOException | NullPointerException ioe) {
            log.info("No configuration property file available. Using default values.");
        }
        return props;
    }

    private static Properties loadProperties(File propertiesFile) {
        Properties props = new Properties();
        try (FileInputStream fis = new FileInputStream(propertiesFile);){
            props.load(fis);
        }
        catch (IOException ioe) {
            log.warn("Cannot read configuration property file %s.", new Object[]{propertiesFile.getAbsolutePath()});
        }
        return props;
    }

    private static Context getInitialContext(String ... args) {
        Context context = new Context();
        Map<String, Object> contextProperties = context.getProperties();
        Options options = new Options();
        DefaultParser commandLineParser = new DefaultParser();
        System.getProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> contextProperties.put((String)key, value)));
        options.addOption(Option.builder((String)PROPERTY_LETTER).argName("property=value").numberOfArgs(2).valueSeparator().desc("system properties").build());
        options.addOption(Option.builder((String)PROPERTY_FILE_LETTER).longOpt("properties").desc("Custom property file").hasArg().argName("PROPERTY_FILE").build());
        try {
            CommandLine commandLine = commandLineParser.parse(options, args);
            commandLine.getOptionProperties(PROPERTY_LETTER).forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> contextProperties.put((String)key, value)));
            if (commandLine.hasOption(PROPERTY_FILE_LETTER)) {
                File propertiesFile = new File(commandLine.getOptionValue(PROPERTY_FILE_LETTER));
                if (propertiesFile.exists()) {
                    Properties props = Boot.loadProperties();
                    props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> contextProperties.putIfAbsent(key.toString(), val)));
                } else {
                    log.error("Specified property file %s does not exists.", new Object[]{propertiesFile.getAbsolutePath()});
                }
            }
        }
        catch (ParseException pe) {
            log.error("Cannot parse arguments: ", (Throwable)pe);
            new HelpFormatter().printHelp("SilverWare usage:", options);
            System.exit(1);
        }
        Boot.loadProperties().forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, val) -> contextProperties.putIfAbsent(key.toString(), val)));
        context.getProperties().put("silverware.shutdown", "true");
        return context;
    }
}

