/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.frame;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.rsocket.frame.FrameHeaderCodec;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.SetupFrameCodec;
import java.util.UUID;

public class ResumeFrameCodec {
    static final int CURRENT_VERSION = SetupFrameCodec.CURRENT_VERSION;

    public static ByteBuf encode(ByteBufAllocator allocator, ByteBuf token, long lastReceivedServerPos, long firstAvailableClientPos) {
        ByteBuf byteBuf = FrameHeaderCodec.encodeStreamZero(allocator, FrameType.RESUME, 0);
        byteBuf.writeInt(CURRENT_VERSION);
        token.markReaderIndex();
        byteBuf.writeShort(token.readableBytes());
        byteBuf.writeBytes(token);
        token.resetReaderIndex();
        byteBuf.writeLong(lastReceivedServerPos);
        byteBuf.writeLong(firstAvailableClientPos);
        return byteBuf;
    }

    public static int version(ByteBuf byteBuf) {
        FrameHeaderCodec.ensureFrameType(FrameType.RESUME, byteBuf);
        byteBuf.markReaderIndex();
        byteBuf.skipBytes(FrameHeaderCodec.size());
        int version = byteBuf.readInt();
        byteBuf.resetReaderIndex();
        return version;
    }

    public static ByteBuf token(ByteBuf byteBuf) {
        FrameHeaderCodec.ensureFrameType(FrameType.RESUME, byteBuf);
        byteBuf.markReaderIndex();
        int tokenPos = FrameHeaderCodec.size() + 4;
        byteBuf.skipBytes(tokenPos);
        int tokenLength = byteBuf.readShort() & 0xFFFF;
        ByteBuf token = byteBuf.readSlice(tokenLength);
        byteBuf.resetReaderIndex();
        return token;
    }

    public static long lastReceivedServerPos(ByteBuf byteBuf) {
        FrameHeaderCodec.ensureFrameType(FrameType.RESUME, byteBuf);
        byteBuf.markReaderIndex();
        int tokenPos = FrameHeaderCodec.size() + 4;
        byteBuf.skipBytes(tokenPos);
        int tokenLength = byteBuf.readShort() & 0xFFFF;
        byteBuf.skipBytes(tokenLength);
        long lastReceivedServerPos = byteBuf.readLong();
        byteBuf.resetReaderIndex();
        return lastReceivedServerPos;
    }

    public static long firstAvailableClientPos(ByteBuf byteBuf) {
        FrameHeaderCodec.ensureFrameType(FrameType.RESUME, byteBuf);
        byteBuf.markReaderIndex();
        int tokenPos = FrameHeaderCodec.size() + 4;
        byteBuf.skipBytes(tokenPos);
        int tokenLength = byteBuf.readShort() & 0xFFFF;
        byteBuf.skipBytes(tokenLength);
        byteBuf.skipBytes(8);
        long firstAvailableClientPos = byteBuf.readLong();
        byteBuf.resetReaderIndex();
        return firstAvailableClientPos;
    }

    public static ByteBuf generateResumeToken() {
        UUID uuid = UUID.randomUUID();
        ByteBuf bb = Unpooled.buffer((int)16);
        bb.writeLong(uuid.getMostSignificantBits());
        bb.writeLong(uuid.getLeastSignificantBits());
        return bb;
    }
}

