/*
 * Decompiled with CFR 0.152.
 */
package io.quarkiverse.operatorsdk.runtime;

import io.javaoperatorsdk.operator.Operator;
import io.quarkiverse.operatorsdk.runtime.QuarkusConfigurationService;
import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import jakarta.annotation.Priority;
import jakarta.enterprise.event.Observes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppEventListener {
    private static final Logger log = LoggerFactory.getLogger(AppEventListener.class);
    private final Operator operator;
    private final QuarkusConfigurationService configurationService;

    public AppEventListener(Operator operator, QuarkusConfigurationService configurationService) {
        this.operator = operator;
        this.configurationService = configurationService;
    }

    public void onStartup(@Observes @Priority(value=3123) StartupEvent event) {
        if (this.configurationService.shouldStartOperator()) {
            if (this.operator.getRegisteredControllersNumber() > 0) {
                log.info("Starting operator.");
                this.operator.start();
            } else {
                log.warn("No Reconciler implementation was found so the Operator was not started.");
            }
        } else {
            log.warn("Operator was configured not to start automatically, call the start method to start it.");
        }
    }

    public void onShutdown(@Observes ShutdownEvent event) {
        if (this.configurationService.shouldStartOperator()) {
            log.info("Quarkus Java Operator SDK extension is shutting down. Is standard shutdown: {}", (Object)event.isStandardShutdown());
            this.operator.stop();
        } else {
            log.warn("Operator was configured not to stop automatically, call the stop method to stop it.");
        }
    }
}

