/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.websocket;

import io.micronaut.context.annotation.Requirements;
import io.micronaut.context.annotation.Requires;
import io.micronaut.context.event.ApplicationEventListener;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.convert.value.MutableConvertibleValues;
import io.micronaut.session.Session;
import io.micronaut.session.SessionStore;
import io.micronaut.websocket.event.WebSocketEvent;
import io.micronaut.websocket.event.WebSocketMessageProcessedEvent;
import io.micronaut.websocket.event.WebSocketSessionClosedEvent;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Requirements(value={@Requires(classes={WebSocketEvent.class}), @Requires(beans={SessionStore.class})})
@Singleton
@Internal
public class SessionWebSocketEventListener
implements ApplicationEventListener<WebSocketEvent> {
    private static final Logger LOG = LoggerFactory.getLogger(SessionWebSocketEventListener.class);
    private final SessionStore<Session> sessionStore;

    SessionWebSocketEventListener(SessionStore<Session> sessionStore) {
        this.sessionStore = sessionStore;
    }

    public void onApplicationEvent(WebSocketEvent event) {
        Session session;
        MutableConvertibleValues attributes;
        if ((event instanceof WebSocketMessageProcessedEvent || event instanceof WebSocketSessionClosedEvent) && (attributes = event.getSource().getAttributes()) instanceof Session && (session = (Session)attributes).isModified()) {
            this.sessionStore.save(session).whenComplete((entries, throwable) -> {
                if (throwable != null && LOG.isErrorEnabled()) {
                    LOG.error("Error persisting session following WebSocket event: " + throwable.getMessage(), throwable);
                }
            });
        }
    }
}

