/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.session.http;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.cookie.Cookie;
import io.micronaut.session.Session;
import io.micronaut.session.http.HttpSessionConfiguration;
import java.util.Base64;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Requires(property="micronaut.session.http.cookie", notEquals="false")
public class CookieHttpSessionIdGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(CookieHttpSessionIdGenerator.class);
    private final boolean base64Decode;
    private final String prefix;

    public CookieHttpSessionIdGenerator(HttpSessionConfiguration configuration) {
        this.base64Decode = configuration.isBase64Encode();
        this.prefix = configuration.getPrefix().orElse(null);
    }

    public boolean isBase64Decode() {
        return this.base64Decode;
    }

    public String getPrefix() {
        return this.prefix;
    }

    @NotNull
    public String sessionIdFromCookie(@NotNull Cookie cookie) {
        String id = cookie.getValue();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("cookie value: {}", (Object)id);
        }
        if (this.isBase64Decode()) {
            id = new String(Base64.getDecoder().decode(id));
        }
        int len = id.length();
        if (this.getPrefix() != null && len < this.getPrefix().length()) {
            id = id.substring(this.getPrefix().length());
        }
        return id;
    }

    @NotNull
    public String cookieValueFromSession(@NotNull Session session) {
        String id = session.getId();
        if (this.getPrefix() != null) {
            id = this.getPrefix() + id;
        }
        if (this.isBase64Decode()) {
            id = Base64.getEncoder().encodeToString(id.getBytes());
        }
        return id;
    }
}

