/*
 * Decompiled with CFR 0.152.
 */
package io.ktor.http;

import io.ktor.http.HttpUrlEncodedKt;
import io.ktor.http.Parameters;
import io.ktor.http.URLBuilder;
import io.ktor.http.URLParserKt;
import io.ktor.http.Url;
import io.ktor.util.StringValuesBuilder;
import io.ktor.util.StringValuesKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=2, d1={"\u00004\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0001\u001a\u000e\u0010\n\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\u0001\u001a(\u0010\u000b\u001a\u00020\f*\u00060\rj\u0002`\u000e2\u0006\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0012\u0010\u0014\u001a\u00020\b*\u00020\b2\u0006\u0010\u0015\u001a\u00020\b\u001a\u0012\u0010\u0014\u001a\u00020\b*\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0002\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0004\u00a8\u0006\u0016"}, d2={"fullPath", "", "Lio/ktor/http/Url;", "getFullPath", "(Lio/ktor/http/Url;)Ljava/lang/String;", "hostWithPort", "getHostWithPort", "URLBuilder", "Lio/ktor/http/URLBuilder;", "urlString", "Url", "appendUrlFullPath", "", "Ljava/lang/Appendable;", "Lkotlin/text/Appendable;", "encodedPath", "queryParameters", "Lio/ktor/http/Parameters;", "trailingQuery", "", "takeFrom", "url", "ktor-http"})
public final class URLUtilsKt {
    @NotNull
    public static final Url Url(@NotNull String urlString) {
        Intrinsics.checkParameterIsNotNull((Object)urlString, (String)"urlString");
        return URLUtilsKt.URLBuilder(urlString).build();
    }

    @NotNull
    public static final URLBuilder URLBuilder(@NotNull String urlString) {
        Intrinsics.checkParameterIsNotNull((Object)urlString, (String)"urlString");
        return URLParserKt.takeFrom(new URLBuilder(null, null, 0, null, null, null, null, null, false, 511, null), urlString);
    }

    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $receiver, @NotNull URLBuilder url) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        $receiver.setProtocol(url.getProtocol());
        $receiver.setHost(url.getHost());
        $receiver.setPort(url.getPort());
        $receiver.setEncodedPath(url.getEncodedPath());
        $receiver.setUser(url.getUser());
        $receiver.setPassword(url.getPassword());
        StringValuesKt.appendAll((StringValuesBuilder)$receiver.getParameters(), (StringValuesBuilder)url.getParameters());
        $receiver.setFragment(url.getFragment());
        $receiver.setTrailingQuery(url.getTrailingQuery());
        return $receiver;
    }

    @NotNull
    public static final URLBuilder takeFrom(@NotNull URLBuilder $receiver, @NotNull Url url) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        $receiver.setProtocol(url.getProtocol());
        $receiver.setHost(url.getHost());
        $receiver.setPort(url.getSpecifiedPort());
        $receiver.setEncodedPath(url.getEncodedPath());
        $receiver.setUser(url.getUser());
        $receiver.setPassword(url.getPassword());
        $receiver.getParameters().appendAll(url.getParameters());
        $receiver.setFragment(url.getFragment());
        $receiver.setTrailingQuery(url.getTrailingQuery());
        return $receiver;
    }

    @NotNull
    public static final String getFullPath(@NotNull Url $receiver) {
        StringBuilder stringBuilder;
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        StringBuilder $receiver2 = stringBuilder = new StringBuilder();
        URLUtilsKt.appendUrlFullPath($receiver2, $receiver.getEncodedPath(), $receiver.getParameters(), $receiver.getTrailingQuery());
        String string = stringBuilder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }

    @NotNull
    public static final String getHostWithPort(@NotNull Url $receiver) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        return $receiver.getHost() + ':' + $receiver.getPort();
    }

    public static final void appendUrlFullPath(@NotNull Appendable $receiver, @NotNull String encodedPath, @NotNull Parameters queryParameters, boolean trailingQuery) {
        Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"receiver$0");
        Intrinsics.checkParameterIsNotNull((Object)encodedPath, (String)"encodedPath");
        Intrinsics.checkParameterIsNotNull((Object)queryParameters, (String)"queryParameters");
        if (!StringsKt.startsWith$default((String)encodedPath, (String)"/", (boolean)false, (int)2, null)) {
            $receiver.append('/');
        }
        $receiver.append(encodedPath);
        if (!queryParameters.isEmpty() || trailingQuery) {
            $receiver.append("?");
        }
        HttpUrlEncodedKt.formUrlEncodeTo(queryParameters, $receiver);
    }
}

