package io.knotx.server.configuration;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter for {@link io.knotx.server.configuration.DropRequestOptions}.
 * NOTE: This class has been automatically generated from the {@link io.knotx.server.configuration.DropRequestOptions} original class using Vert.x codegen.
 */
 class DropRequestOptionsConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, DropRequestOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "backpressureBufferCapacity":
          if (member.getValue() instanceof Number) {
            obj.setBackpressureBufferCapacity(((Number)member.getValue()).longValue());
          }
          break;
        case "backpressureStrategy":
          if (member.getValue() instanceof String) {
            obj.setBackpressureStrategy(io.reactivex.BackpressureOverflowStrategy.valueOf((String)member.getValue()));
          }
          break;
        case "dropRequestResponseCode":
          if (member.getValue() instanceof Number) {
            obj.setDropRequestResponseCode(((Number)member.getValue()).intValue());
          }
          break;
        case "enabled":
          if (member.getValue() instanceof Boolean) {
            obj.setEnabled((Boolean)member.getValue());
          }
          break;
      }
    }
  }

   static void toJson(DropRequestOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(DropRequestOptions obj, java.util.Map<String, Object> json) {
    json.put("backpressureBufferCapacity", obj.getBackpressureBufferCapacity());
    if (obj.getBackpressureStrategy() != null) {
      json.put("backpressureStrategy", obj.getBackpressureStrategy().name());
    }
    json.put("dropRequestResponseCode", obj.getDropRequestResponseCode());
    json.put("enabled", obj.isEnabled());
  }
}
