/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.jetty;

import io.javalin.core.LoomUtil;
import io.javalin.core.util.JavalinLogger;
import io.javalin.jetty.JettyServer;
import io.javalin.jetty.JettyUtilKt;
import io.javalin.jetty.LoomThreadPool;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.server.LowResourceMonitor;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.server.handler.StatisticsHandler;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0019B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0007J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000fH\u0007J\u000e\u0010\u0011\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\u0013J\u0010\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u0017H\u0007J\u0006\u0010\u0018\u001a\u00020\rR\u0012\u0010\u0003\u001a\u00020\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\u001a"}, d2={"Lio/javalin/jetty/JettyUtil;", "", "()V", "logDuringStartup", "", "logIfNotStarted", "getLogIfNotStarted", "()Z", "setLogIfNotStarted", "(Z)V", "defaultThreadPool", "Lorg/eclipse/jetty/util/thread/ThreadPool;", "disableJettyLogger", "", "getOrDefault", "Lorg/eclipse/jetty/server/Server;", "server", "isClientAbortException", "t", "", "isJettyTimeoutException", "maybeLogIfServerNotStarted", "jettyServer", "Lio/javalin/jetty/JettyServer;", "reEnableJettyLogger", "NoopLogger", "javalin"})
public final class JettyUtil {
    @NotNull
    public static final JettyUtil INSTANCE = new JettyUtil();
    @JvmField
    public static boolean logDuringStartup;
    private static boolean logIfNotStarted;

    private JettyUtil() {
    }

    @JvmStatic
    @NotNull
    public static final Server getOrDefault(@Nullable Server server) {
        Server server2;
        Server server3 = server;
        if (server3 == null) {
            Server server4 = new Server(INSTANCE.defaultThreadPool());
            boolean bl = false;
            boolean bl2 = false;
            Server $this$getOrDefault_u24lambda_u2d0 = server4;
            boolean bl3 = false;
            $this$getOrDefault_u24lambda_u2d0.addBean((Object)new LowResourceMonitor($this$getOrDefault_u24lambda_u2d0));
            $this$getOrDefault_u24lambda_u2d0.insertHandler((HandlerWrapper)new StatisticsHandler());
            $this$getOrDefault_u24lambda_u2d0.setAttribute("is-default-server", (Object)true);
            server2 = server4;
        } else {
            server2 = server3;
        }
        return server2;
    }

    private final ThreadPool defaultThreadPool() {
        ThreadPool threadPool;
        if (LoomUtil.useLoomThreadPool && LoomUtil.INSTANCE.getLoomAvailable()) {
            JavalinLogger.info$default("Loom is available, using Virtual ThreadPool... Neat!", null, 2, null);
            threadPool = new LoomThreadPool();
        } else {
            threadPool = (ThreadPool)new QueuedThreadPool(250, 8, 60000);
        }
        return threadPool;
    }

    @JvmStatic
    public static final void disableJettyLogger() {
        if (logDuringStartup) {
            return;
        }
        Logger logger = JettyUtilKt.access$getDefaultLogger$p();
        JettyUtilKt.access$setDefaultLogger$p(logger == null ? Log.getLog() : logger);
        Log.setLog((Logger)new NoopLogger());
    }

    public final void reEnableJettyLogger() {
        if (logDuringStartup) {
            return;
        }
        Log.setLog((Logger)JettyUtilKt.access$getDefaultLogger$p());
    }

    public final boolean getLogIfNotStarted() {
        return logIfNotStarted;
    }

    public final void setLogIfNotStarted(boolean bl) {
        logIfNotStarted = bl;
    }

    @JvmStatic
    public static final void maybeLogIfServerNotStarted(@NotNull JettyServer jettyServer) {
        Intrinsics.checkNotNullParameter((Object)jettyServer, (String)"jettyServer");
        new Thread(() -> JettyUtil.maybeLogIfServerNotStarted$lambda-1(jettyServer)).start();
    }

    public final boolean isClientAbortException(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return Intrinsics.areEqual((Object)t.getClass().getName(), (Object)"org.eclipse.jetty.io.EofException");
    }

    public final boolean isJettyTimeoutException(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return t instanceof IOException && t.getCause() instanceof TimeoutException;
    }

    private static final void maybeLogIfServerNotStarted$lambda-1(JettyServer $jettyServer) {
        Intrinsics.checkNotNullParameter((Object)$jettyServer, (String)"$jettyServer");
        Thread.sleep(5000L);
        if (INSTANCE.getLogIfNotStarted() && !$jettyServer.started) {
            JavalinLogger.info$default("It looks like you created a Javalin instance, but you never started it.", null, 2, null);
            JavalinLogger.info$default("Try: Javalin app = Javalin.create().start();", null, 2, null);
            JavalinLogger.info$default("For more help, visit https://javalin.io/documentation#starting-and-stopping", null, 2, null);
        }
    }

    static {
        logIfNotStarted = true;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0006H\u0016J\b\u0010\u0012\u001a\u00020\u0006H\u0016J\u0010\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000fH\u0016J)\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0017H\u0016J)\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\"\u00020\tH\u0016\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u001a\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u001b"}, d2={"Lio/javalin/jetty/JettyUtil$NoopLogger;", "Lorg/eclipse/jetty/util/log/Logger;", "()V", "debug", "", "msg", "", "args", "", "", "(Ljava/lang/String;[Ljava/lang/Object;)V", "s", "l", "", "thrown", "", "getLogger", "name", "getName", "ignore", "ignored", "info", "isDebugEnabled", "", "setDebugEnabled", "enabled", "warn", "javalin"})
    public static final class NoopLogger
    implements Logger {
        @NotNull
        public String getName() {
            return "noop";
        }

        @NotNull
        public NoopLogger getLogger(@NotNull String name) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            return this;
        }

        public void setDebugEnabled(boolean enabled) {
        }

        public boolean isDebugEnabled() {
            return false;
        }

        public void ignore(@NotNull Throwable ignored) {
            Intrinsics.checkNotNullParameter((Object)ignored, (String)"ignored");
        }

        public void warn(@NotNull String msg, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public void warn(@NotNull Throwable thrown) {
            Intrinsics.checkNotNullParameter((Object)thrown, (String)"thrown");
        }

        public void warn(@NotNull String msg, @NotNull Throwable thrown) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)thrown, (String)"thrown");
        }

        public void info(@NotNull String msg, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public void info(@NotNull Throwable thrown) {
            Intrinsics.checkNotNullParameter((Object)thrown, (String)"thrown");
        }

        public void info(@NotNull String msg, @NotNull Throwable thrown) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)thrown, (String)"thrown");
        }

        public void debug(@NotNull String msg, Object ... args) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        }

        public void debug(@NotNull String s, long l) {
            Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        }

        public void debug(@NotNull Throwable thrown) {
            Intrinsics.checkNotNullParameter((Object)thrown, (String)"thrown");
        }

        public void debug(@NotNull String msg, @NotNull Throwable thrown) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            Intrinsics.checkNotNullParameter((Object)thrown, (String)"thrown");
        }
    }
}

