/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http.util;

import io.javalin.core.security.BasicAuthCredentials;
import io.javalin.core.util.JavalinLogger;
import io.javalin.http.Context;
import io.javalin.http.HandlerEntry;
import io.javalin.http.HandlerType;
import io.javalin.http.HttpCode;
import io.javalin.http.HttpResponseException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u000e\u001a\u00020\u000fJ\u0016\u0010\u0010\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004J#\u0010\u0014\u001a\u0004\u0018\u0001H\u0015\"\u0004\b\u0000\u0010\u00152\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u00042\u0006\u0010\b\u001a\u00020\tJ\u0010\u0010\u0018\u001a\u00020\u00072\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004JX\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001c2\b\b\u0002\u0010\u001d\u001a\u00020\u00042\u0014\b\u0002\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001f2\b\b\u0002\u0010 \u001a\u00020!2\u0014\b\u0002\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\u001fH\u0007J,\u0010#\u001a\u00020\u00042\u0014\u0010$\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u001f2\u0006\u0010\f\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J\u001a\u0010&\u001a\u0004\u0018\u00010\u00042\b\u0010'\u001a\u0004\u0018\u00010(2\u0006\u0010)\u001a\u00020*J(\u0010+\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040,0\u001f2\u0006\u0010-\u001a\u00020\u00042\u0006\u0010)\u001a\u00020\u0004J\u001e\u0010.\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\u0004J\u000e\u00102\u001a\u00020\u00042\u0006\u00103\u001a\u00020\u0004J\n\u00104\u001a\u00020\u0007*\u00020\tJ\n\u00105\u001a\u00020\u000b*\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u00066"}, d2={"Lio/javalin/http/util/ContextUtil;", "", "()V", "maxRequestSizeKey", "", "sessionCacheKeyPrefix", "acceptsHtml", "", "ctx", "Lio/javalin/http/Context;", "cacheAndSetSessionAttribute", "", "key", "value", "req", "Ljavax/servlet/http/HttpServletRequest;", "changeBaseRequest", "getBasicAuthCredentials", "Lio/javalin/core/security/BasicAuthCredentials;", "header", "getCachedRequestAttributeOrSessionAttribute", "T", "(Ljava/lang/String;Ljavax/servlet/http/HttpServletRequest;)Ljava/lang/Object;", "getRequestCharset", "hasBasicAuthCredentials", "init", "request", "response", "Ljavax/servlet/http/HttpServletResponse;", "matchedPath", "pathParamMap", "", "handlerType", "Lio/javalin/http/HandlerType;", "appAttributes", "pathParamOrThrow", "pathParams", "url", "readAndResetStreamIfPossible", "stream", "Ljava/io/InputStream;", "charset", "Ljava/nio/charset/Charset;", "splitKeyValueStringAndGroupByKey", "", "string", "update", "handlerEntry", "Lio/javalin/http/HandlerEntry;", "requestUri", "urlDecode", "s", "isLocalhost", "throwPayloadTooLargeIfPayloadTooLarge", "javalin"})
public final class ContextUtil {
    @NotNull
    public static final ContextUtil INSTANCE = new ContextUtil();
    @NotNull
    public static final String maxRequestSizeKey = "javalin-max-request-size";
    @NotNull
    public static final String sessionCacheKeyPrefix = "javalin-session-attribute-cache-";

    private ContextUtil() {
    }

    @NotNull
    public final Context update(@NotNull Context ctx, @NotNull HandlerEntry handlerEntry, @NotNull String requestUri) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)handlerEntry, (String)"handlerEntry");
        Intrinsics.checkNotNullParameter((Object)requestUri, (String)"requestUri");
        Context context = ctx;
        boolean bl = false;
        boolean bl2 = false;
        Context $this$update_u24lambda_u2d0 = context;
        boolean bl3 = false;
        $this$update_u24lambda_u2d0.setMatchedPath$javalin(handlerEntry.getPath());
        $this$update_u24lambda_u2d0.setPathParamMap$javalin(handlerEntry.extractPathParams(requestUri));
        $this$update_u24lambda_u2d0.setHandlerType$javalin(handlerEntry.getType());
        if ($this$update_u24lambda_u2d0.getHandlerType$javalin() != HandlerType.AFTER) {
            $this$update_u24lambda_u2d0.setEndpointHandlerPath$javalin(handlerEntry.getPath());
        }
        return context;
    }

    @Nullable
    public final String getRequestCharset(@NotNull Context ctx) {
        String string;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string2 = ctx.req.getHeader("Content-Type");
        if (string2 == null) {
            string = null;
        } else {
            Object v2;
            Object object;
            boolean bl;
            Object object2;
            block7: {
                String string3 = string2;
                boolean bl2 = false;
                boolean bl3 = false;
                String value = string3;
                boolean bl4 = false;
                object2 = new String[]{";"};
                object2 = StringsKt.split$default((CharSequence)value, (String[])object2, (boolean)false, (int)0, (int)6, null);
                bl = false;
                Object object3 = object2;
                boolean bl5 = false;
                Iterator iterator = object3.iterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    String it = (String)object;
                    boolean bl6 = false;
                    String string4 = it;
                    boolean bl7 = false;
                    String string5 = string4;
                    if (string5 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                    }
                    if (!StringsKt.startsWith((String)((Object)StringsKt.trim((CharSequence)string5)).toString(), (String)"charset", (boolean)true)) continue;
                    v2 = object;
                    break block7;
                }
                v2 = null;
            }
            String string6 = v2;
            if (string6 == null) {
                string = null;
            } else {
                object2 = string6;
                bl = false;
                boolean bl8 = false;
                Object it = object2;
                boolean bl9 = false;
                object = new String[]{"="};
                object = (String)StringsKt.split$default((CharSequence)((CharSequence)it), object, (boolean)false, (int)0, (int)6, null).get(1);
                boolean bl10 = false;
                Object object4 = object;
                if (object4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                string = ((Object)StringsKt.trim((CharSequence)((CharSequence)object4))).toString();
            }
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, List<String>> splitKeyValueStringAndGroupByKey(@NotNull String string, @NotNull String charset) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        String[] stringArray = (String[])string;
        boolean bl = false;
        if (stringArray.length() == 0) {
            boolean bl2 = false;
            object = MapsKt.emptyMap();
        } else {
            void $this$mapValuesTo$iv$iv;
            Object answer$iv$iv$iv;
            Object key$iv$iv;
            Object $this$groupByTo$iv$iv;
            Object object2;
            List it;
            Object object3;
            Iterable $this$mapTo$iv$iv;
            stringArray = new String[]{"&"};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Object destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String string2 = (String)item$iv$iv;
                object3 = destination$iv$iv;
                boolean bl3 = false;
                String[] stringArray2 = new String[]{"="};
                object2 = StringsKt.split$default((CharSequence)((CharSequence)((Object)it)), (String[])stringArray2, (boolean)false, (int)2, (int)2, null);
                object3.add(object2);
            }
            Iterable $this$groupBy$iv = (List)destination$iv$iv;
            boolean $i$f$groupBy = false;
            $this$mapTo$iv$iv = $this$groupBy$iv;
            destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            Iterator iterator = $this$groupByTo$iv$iv.iterator();
            while (iterator.hasNext()) {
                Object object4;
                Object element$iv$iv = iterator.next();
                it = (List)element$iv$iv;
                boolean bl4 = false;
                key$iv$iv = URLDecoder.decode((String)it.get(0), charset);
                Object $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get(key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl5 = false;
                    answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object4 = answer$iv$iv$iv;
                } else {
                    object4 = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object4;
                it = (List)element$iv$iv;
                object3 = list$iv$iv;
                boolean bl6 = false;
                object2 = it.size() > 1 ? URLDecoder.decode((String)it.get(1), charset) : "";
                object3.add(object2);
            }
            Object $this$mapValues$iv = destination$iv$iv;
            boolean $i$f$mapValues = false;
            $this$groupByTo$iv$iv = $this$mapValues$iv;
            destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
            boolean $i$f$mapValuesTo = false;
            Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
                void it2;
                void it$iv$iv;
                key$iv$iv = (Map.Entry)element$iv$iv$iv;
                Object object5 = destination$iv$iv;
                boolean bl7 = false;
                Object k = it$iv$iv.getKey();
                answer$iv$iv$iv = (Map.Entry)element$iv$iv$iv;
                object2 = k;
                object3 = object5;
                boolean bl8 = false;
                List list = CollectionsKt.toList((Iterable)((Iterable)it2.getValue()));
                object3.put(object2, list);
            }
            object = destination$iv$iv;
        }
        return object;
    }

    @NotNull
    public final String pathParamOrThrow(@NotNull Map<String, String> pathParams, @NotNull String key, @NotNull String url) {
        Intrinsics.checkNotNullParameter(pathParams, (String)"pathParams");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = pathParams.get(StringsKt.replaceFirst$default((String)StringsKt.replaceFirst$default((String)key, (String)"{", (String)"", (boolean)false, (int)4, null), (String)"}", (String)"", (boolean)false, (int)4, null));
        if (string == null) {
            throw new IllegalArgumentException('\'' + key + "' is not a valid path-param for '" + url + "'.");
        }
        return string;
    }

    @NotNull
    public final String urlDecode(@NotNull String s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        String string = URLDecoder.decode(StringsKt.replace$default((String)s, (String)"+", (String)"%2B", (boolean)false, (int)4, null), "UTF-8");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"decode(s.replace(\"+\", \"%2B\"), \"UTF-8\")");
        return StringsKt.replace$default((String)string, (String)"%2B", (String)"+", (boolean)false, (int)4, null);
    }

    public final boolean hasBasicAuthCredentials(@Nullable String header) {
        boolean bl;
        try {
            this.getBasicAuthCredentials(header);
            bl = true;
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final BasicAuthCredentials getBasicAuthCredentials(@Nullable String header) {
        List list;
        String string = header;
        boolean bl = string == null ? false : StringsKt.startsWith$default((String)string, (String)"Basic ", (boolean)false, (int)2, null);
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string2 = "Invalid basicauth header. Value was '" + header + "'.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Base64.Decoder decoder = Base64.getDecoder();
        String string3 = header;
        Intrinsics.checkNotNull((Object)string3);
        Object[] objectArray = decoder.decode(StringsKt.removePrefix((String)string3, (CharSequence)"Basic "));
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getDecoder().decode(head\u2026!.removePrefix(\"Basic \"))");
        bl3 = false;
        String string4 = new String((byte[])objectArray, Charsets.UTF_8);
        objectArray = new char[1];
        objectArray[0] = 58;
        List list2 = list = StringsKt.split$default((CharSequence)string4, (char[])objectArray, (boolean)false, (int)2, (int)2, null);
        boolean bl5 = false;
        String username = (String)list2.get(0);
        List list3 = list;
        boolean bl6 = false;
        String password = (String)list3.get(1);
        return new BasicAuthCredentials(username, password);
    }

    public final boolean acceptsHtml(@NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        String string = ctx.header("Accept");
        return string == null ? false : StringsKt.contains$default((CharSequence)string, (CharSequence)"text/html", (boolean)false, (int)2, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Context init(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String matchedPath, @NotNull Map<String, String> pathParamMap, @NotNull HandlerType handlerType, @NotNull Map<String, ? extends Object> appAttributes) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)matchedPath, (String)"matchedPath");
        Intrinsics.checkNotNullParameter(pathParamMap, (String)"pathParamMap");
        Intrinsics.checkNotNullParameter((Object)((Object)handlerType), (String)"handlerType");
        Intrinsics.checkNotNullParameter(appAttributes, (String)"appAttributes");
        Context context = new Context(request, response, appAttributes);
        boolean bl = false;
        boolean bl2 = false;
        Context $this$init_u24lambda_u2d9 = context;
        boolean bl3 = false;
        $this$init_u24lambda_u2d9.setMatchedPath$javalin(matchedPath);
        $this$init_u24lambda_u2d9.setPathParamMap$javalin(pathParamMap);
        $this$init_u24lambda_u2d9.setHandlerType$javalin(handlerType);
        return context;
    }

    public static /* synthetic */ Context init$default(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String string, Map map, HandlerType handlerType, Map map2, int n, Object object) {
        boolean bl;
        if ((n & 4) != 0) {
            string = "*";
        }
        if ((n & 8) != 0) {
            bl = false;
            map = MapsKt.emptyMap();
        }
        if ((n & 0x10) != 0) {
            handlerType = HandlerType.INVALID;
        }
        if ((n & 0x20) != 0) {
            bl = false;
            map2 = MapsKt.emptyMap();
        }
        return ContextUtil.init(httpServletRequest, httpServletResponse, string, map, handlerType, map2);
    }

    public final boolean isLocalhost(@NotNull Context $this$isLocalhost) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isLocalhost, (String)"<this>");
        try {
            String string = new URL($this$isLocalhost.url()).getHost();
            boolean bl2 = false;
            boolean bl3 = false;
            String it = string;
            boolean bl4 = false;
            bl = Intrinsics.areEqual((Object)it, (Object)"localhost") || Intrinsics.areEqual((Object)it, (Object)"127.0.0.1");
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    @NotNull
    public final Context changeBaseRequest(@NotNull Context ctx, @NotNull HttpServletRequest req) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Context context = new Context(req, ctx.res, ctx.getAppAttributes$javalin());
        boolean bl = false;
        boolean bl2 = false;
        Context $this$changeBaseRequest_u24lambda_u2d11 = context;
        boolean bl3 = false;
        $this$changeBaseRequest_u24lambda_u2d11.setPathParamMap$javalin(ctx.getPathParamMap$javalin());
        $this$changeBaseRequest_u24lambda_u2d11.setMatchedPath$javalin(ctx.getMatchedPath$javalin());
        return context;
    }

    public final void throwPayloadTooLargeIfPayloadTooLarge(@NotNull Context $this$throwPayloadTooLargeIfPayloadTooLarge) {
        Intrinsics.checkNotNullParameter((Object)$this$throwPayloadTooLargeIfPayloadTooLarge, (String)"<this>");
        long maxRequestSize = ((Number)$this$throwPayloadTooLargeIfPayloadTooLarge.appAttribute(maxRequestSizeKey)).longValue();
        if ((long)$this$throwPayloadTooLargeIfPayloadTooLarge.req.getContentLength() > maxRequestSize) {
            JavalinLogger.warn$default("Body greater than max size (" + maxRequestSize + " bytes)", null, 2, null);
            throw new HttpResponseException(HttpCode.PAYLOAD_TOO_LARGE.getStatus(), HttpCode.PAYLOAD_TOO_LARGE.getMessage(), null, 4, null);
        }
    }

    public final void cacheAndSetSessionAttribute(@NotNull String key, @Nullable Object value, @NotNull HttpServletRequest req) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        req.setAttribute(Intrinsics.stringPlus((String)sessionCacheKeyPrefix, (Object)key), value);
        req.getSession().setAttribute(key, value);
    }

    @Nullable
    public final <T> T getCachedRequestAttributeOrSessionAttribute(@NotNull String key, @NotNull HttpServletRequest req) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Intrinsics.checkNotNullParameter((Object)req, (String)"req");
        Object cachedAttribute = req.getAttribute(Intrinsics.stringPlus((String)sessionCacheKeyPrefix, (Object)key));
        if (cachedAttribute == null) {
            req.setAttribute(Intrinsics.stringPlus((String)sessionCacheKeyPrefix, (Object)key), req.getSession().getAttribute(key));
        }
        return (T)req.getAttribute(Intrinsics.stringPlus((String)sessionCacheKeyPrefix, (Object)key));
    }

    @Nullable
    public final String readAndResetStreamIfPossible(@Nullable InputStream stream, @NotNull Charset charset) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        try {
            String string;
            object = stream;
            if (object == null) {
                string = null;
            } else {
                Object object2 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object $this$readAndResetStreamIfPossible_u24lambda_u2d12 = object2;
                boolean bl3 = false;
                ((InputStream)$this$readAndResetStreamIfPossible_u24lambda_u2d12).reset();
                Object object3 = object2;
                object2 = ByteStreamsKt.readBytes((InputStream)object3);
                if (object2 == null) {
                    string = null;
                } else {
                    Object object4 = object2;
                    bl2 = false;
                    boolean bl4 = false;
                    string = new String((byte[])object4, charset);
                }
            }
            object = string;
            boolean bl = false;
            boolean bl5 = false;
            Object it = object;
            boolean bl6 = false;
            InputStream inputStream = stream;
            if (inputStream != null) {
                inputStream.reset();
            }
        }
        catch (Exception e) {
            object = "resultString unavailable (resultStream couldn't be reset)";
        }
        return object;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Context init(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String matchedPath, @NotNull Map<String, String> pathParamMap, @NotNull HandlerType handlerType) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)matchedPath, (String)"matchedPath");
        Intrinsics.checkNotNullParameter(pathParamMap, (String)"pathParamMap");
        Intrinsics.checkNotNullParameter((Object)((Object)handlerType), (String)"handlerType");
        return ContextUtil.init$default(request, response, matchedPath, pathParamMap, handlerType, null, 32, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Context init(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String matchedPath, @NotNull Map<String, String> pathParamMap) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)matchedPath, (String)"matchedPath");
        Intrinsics.checkNotNullParameter(pathParamMap, (String)"pathParamMap");
        return ContextUtil.init$default(request, response, matchedPath, pathParamMap, null, null, 48, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Context init(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response, @NotNull String matchedPath) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        Intrinsics.checkNotNullParameter((Object)matchedPath, (String)"matchedPath");
        return ContextUtil.init$default(request, response, matchedPath, null, null, null, 56, null);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final Context init(@NotNull HttpServletRequest request, @NotNull HttpServletResponse response) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        return ContextUtil.init$default(request, response, null, null, null, null, 60, null);
    }
}

