/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http;

import io.javalin.core.util.Util;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.http.SinglePageHandlerKt;
import io.javalin.http.staticfiles.Location;
import io.javalin.http.util.ContextUtil;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0006J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000fJ\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\b0\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lio/javalin/http/SinglePageHandler;", "", "()V", "pathHandlerMap", "", "", "Lio/javalin/http/Handler;", "pathPageMap", "Lio/javalin/http/SinglePageHandler$Page;", "add", "", "hostedPath", "handler", "filePath", "location", "Lio/javalin/http/staticfiles/Location;", "handle", "", "ctx", "Lio/javalin/http/Context;", "Page", "javalin"})
public final class SinglePageHandler {
    @NotNull
    private final Map<String, Page> pathPageMap;
    @NotNull
    private final Map<String, Handler> pathHandlerMap;

    public SinglePageHandler() {
        boolean bl = false;
        this.pathPageMap = new LinkedHashMap();
        bl = false;
        this.pathHandlerMap = new LinkedHashMap();
    }

    public final void add(@NotNull String hostedPath, @NotNull String filePath, @NotNull Location location) {
        URL uRL;
        Object object;
        Intrinsics.checkNotNullParameter((Object)hostedPath, (String)"hostedPath");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)((Object)location), (String)"location");
        Object object2 = location;
        int n = WhenMappings.$EnumSwitchMapping$0[((Enum)object2).ordinal()];
        switch (n) {
            case 1: {
                object = Util.getResourceUrl(StringsKt.removePrefix((String)filePath, (CharSequence)"/"));
                if (object == null) {
                    throw new IllegalArgumentException("File at '" + filePath + "' not found. Path should be relative to resource folder.");
                }
                uRL = object;
                break;
            }
            case 2: {
                object = Util.INSTANCE.getFileUrl(filePath);
                if (object == null) {
                    throw new IllegalArgumentException("External file at '" + filePath + "' not found.");
                }
                uRL = object;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        URL url = uRL;
        object2 = this.pathPageMap;
        Object object3 = url;
        object = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = TextStreamsKt.readBytes((URL)object3);
        boolean bl2 = false;
        boolean bl3 = false;
        object3 = new Page(url, new String(byArray, (Charset)object));
        boolean bl4 = false;
        object2.put(hostedPath, object3);
    }

    public final void add(@NotNull String hostedPath, @NotNull Handler handler) {
        Intrinsics.checkNotNullParameter((Object)hostedPath, (String)"hostedPath");
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        Map<String, Handler> map = this.pathHandlerMap;
        boolean bl = false;
        map.put(hostedPath, handler);
    }

    public final boolean handle(@NotNull Context ctx) {
        String accept;
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Object object = ctx.header("Accept");
        String string = accept = object == null ? "" : object;
        if (!(StringsKt.contains$default((CharSequence)accept, (CharSequence)"text/html", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)accept, (CharSequence)"*/*", (boolean)false, (int)2, null) || Intrinsics.areEqual((Object)accept, (Object)""))) {
            return false;
        }
        object = (Page)SinglePageHandlerKt.access$findByPath(this.pathPageMap, ctx.path());
        if (object != null) {
            Object object2 = object;
            boolean bl = false;
            boolean bl2 = false;
            Object page = object2;
            boolean bl3 = false;
            ctx.html(((Page)page).getHtml(ContextUtil.INSTANCE.isLocalhost(ctx)));
            return true;
        }
        object = (Handler)SinglePageHandlerKt.access$findByPath(this.pathHandlerMap, ctx.path());
        if (object != null) {
            Object object3 = object;
            boolean bl = false;
            boolean bl4 = false;
            Object handler = object3;
            boolean bl5 = false;
            handler.handle(ctx);
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u000fJ\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lio/javalin/http/SinglePageHandler$Page;", "", "url", "Ljava/net/URL;", "cachedHtml", "", "(Ljava/net/URL;Ljava/lang/String;)V", "getCachedHtml", "()Ljava/lang/String;", "getUrl", "()Ljava/net/URL;", "component1", "component2", "copy", "equals", "", "other", "getHtml", "reRead", "hashCode", "", "toString", "javalin"})
    public static final class Page {
        @NotNull
        private final URL url;
        @NotNull
        private final String cachedHtml;

        public Page(@NotNull URL url, @NotNull String cachedHtml) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)cachedHtml, (String)"cachedHtml");
            this.url = url;
            this.cachedHtml = cachedHtml;
        }

        @NotNull
        public final URL getUrl() {
            return this.url;
        }

        @NotNull
        public final String getCachedHtml() {
            return this.cachedHtml;
        }

        @NotNull
        public final String getHtml(boolean reRead) {
            String string;
            if (reRead) {
                URL uRL = this.url;
                Charset charset = Charsets.UTF_8;
                boolean bl = false;
                byte[] byArray = TextStreamsKt.readBytes((URL)uRL);
                boolean bl2 = false;
                boolean bl3 = false;
                string = new String(byArray, charset);
            } else {
                string = this.cachedHtml;
            }
            return string;
        }

        @NotNull
        public final URL component1() {
            return this.url;
        }

        @NotNull
        public final String component2() {
            return this.cachedHtml;
        }

        @NotNull
        public final Page copy(@NotNull URL url, @NotNull String cachedHtml) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)cachedHtml, (String)"cachedHtml");
            return new Page(url, cachedHtml);
        }

        public static /* synthetic */ Page copy$default(Page page, URL uRL, String string, int n, Object object) {
            if ((n & 1) != 0) {
                uRL = page.url;
            }
            if ((n & 2) != 0) {
                string = page.cachedHtml;
            }
            return page.copy(uRL, string);
        }

        @NotNull
        public String toString() {
            return "Page(url=" + this.url + ", cachedHtml=" + this.cachedHtml + ')';
        }

        public int hashCode() {
            int result = this.url.hashCode();
            result = result * 31 + this.cachedHtml.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Page)) {
                return false;
            }
            Page page = (Page)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)page.url)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.cachedHtml, (Object)page.cachedHtml);
        }
    }

    @Metadata(mv={1, 5, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Location.values().length];
            nArray[Location.CLASSPATH.ordinal()] = 1;
            nArray[Location.EXTERNAL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

