/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http;

import io.javalin.core.util.JavalinLogger;
import io.javalin.core.util.Util;
import io.javalin.http.Context;
import io.javalin.http.ExceptionHandler;
import io.javalin.http.HttpResponseException;
import io.javalin.http.HttpResponseExceptionMapper;
import io.javalin.http.InternalServerErrorResponse;
import io.javalin.jetty.JettyUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletionException;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0001\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J'\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\f0\u0010H\u0080\b\u00f8\u0001\u0000\u00a2\u0006\u0002\b\u0011J!\u0010\u0012\u001a\u00020\f2\n\u0010\u0013\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u0014J\u001f\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u001f\u0010\u001a\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u001dJ\u0014\u0010\u001e\u001a\u00020\u001f2\n\u0010 \u001a\u00060\u0006j\u0002`\u0007H\u0002R5\u0010\u0003\u001a&\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u00060\u0006j\u0002`\u00070\u0005\u0012\u0010\u0012\u000e\u0012\b\u0012\u00060\u0006j\u0002`\u0007\u0018\u00010\b0\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006!"}, d2={"Lio/javalin/http/ExceptionMapper;", "", "()V", "handlers", "", "Ljava/lang/Class;", "Ljava/lang/Exception;", "Lkotlin/Exception;", "Lio/javalin/http/ExceptionHandler;", "getHandlers", "()Ljava/util/Map;", "catchException", "", "ctx", "Lio/javalin/http/Context;", "func", "Lkotlin/Function0;", "catchException$javalin", "handle", "exception", "handle$javalin", "handleFutureException", "", "throwable", "", "handleFutureException$javalin", "handleUnexpectedThrowable", "res", "Ljavax/servlet/http/HttpServletResponse;", "handleUnexpectedThrowable$javalin", "noUserHandler", "", "e", "javalin"})
public final class ExceptionMapper {
    @NotNull
    private final Map<Class<? extends Exception>, ExceptionHandler<Exception>> handlers;

    public ExceptionMapper() {
        boolean bl = false;
        this.handlers = new LinkedHashMap();
    }

    @NotNull
    public final Map<Class<? extends Exception>, ExceptionHandler<Exception>> getHandlers() {
        return this.handlers;
    }

    public final void handle$javalin(@NotNull Exception exception, @NotNull Context ctx) {
        Intrinsics.checkNotNullParameter((Object)exception, (String)"exception");
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        ctx.setInExceptionHandler$javalin(true);
        if (HttpResponseExceptionMapper.INSTANCE.canHandle(exception) && this.noUserHandler(exception)) {
            HttpResponseExceptionMapper.INSTANCE.handle(exception, ctx);
        } else {
            ExceptionHandler<Exception> exceptionHandler = Util.INSTANCE.findByClass(this.handlers, exception.getClass());
            if (exceptionHandler != null) {
                exceptionHandler.handle(exception, ctx);
            } else {
                JavalinLogger.warn("Uncaught exception", exception);
                HttpResponseExceptionMapper.INSTANCE.handle(new InternalServerErrorResponse(null, null, 3, null), ctx);
            }
        }
        ctx.setInExceptionHandler$javalin(false);
    }

    public final void catchException$javalin(@NotNull Context ctx, @NotNull Function0<Unit> func) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter(func, (String)"func");
        boolean $i$f$catchException$javalin = false;
        try {
            func.invoke();
        }
        catch (Exception e) {
            this.handle$javalin(e, ctx);
        }
    }

    @Nullable
    public final Void handleFutureException$javalin(@NotNull Context ctx, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (throwable instanceof CompletionException && throwable.getCause() instanceof Exception) {
            Throwable throwable2 = throwable.getCause();
            if (throwable2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.Exception{ kotlin.TypeAliasesKt.Exception }");
            }
            this.handle$javalin((Exception)throwable2, ctx);
        } else if (throwable instanceof Exception) {
            this.handle$javalin((Exception)throwable, ctx);
        }
        return null;
    }

    @Nullable
    public final Void handleUnexpectedThrowable$javalin(@NotNull HttpServletResponse res, @NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)res, (String)"res");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        if (JettyUtil.INSTANCE.isClientAbortException(throwable)) {
            return null;
        }
        if (JettyUtil.INSTANCE.isJettyTimeoutException(throwable)) {
            return null;
        }
        res.setStatus(500);
        JavalinLogger.error("Exception occurred while servicing http-request", throwable);
        return null;
    }

    private final boolean noUserHandler(Exception e) {
        return this.handlers.get(e.getClass()) == null && this.handlers.get(HttpResponseException.class) == null;
    }
}

