/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.websocket;

import io.javalin.websocket.WsBinaryMessageContext;
import io.javalin.websocket.WsBinaryMessageHandler;
import io.javalin.websocket.WsCloseContext;
import io.javalin.websocket.WsCloseHandler;
import io.javalin.websocket.WsConnectContext;
import io.javalin.websocket.WsConnectHandler;
import io.javalin.websocket.WsContext;
import io.javalin.websocket.WsEntry;
import io.javalin.websocket.WsErrorContext;
import io.javalin.websocket.WsErrorHandler;
import io.javalin.websocket.WsExceptionMapper;
import io.javalin.websocket.WsHandler;
import io.javalin.websocket.WsHandlerControllerKt;
import io.javalin.websocket.WsMessageContext;
import io.javalin.websocket.WsMessageHandler;
import io.javalin.websocket.WsPathMatcher;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketClose;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketConnect;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketError;
import org.eclipse.jetty.websocket.api.annotations.OnWebSocketMessage;
import org.eclipse.jetty.websocket.api.annotations.WebSocket;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@WebSocket
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\"\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0010H\u0007J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0007J\u001a\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0007J(\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u0017H\u0007J\u0018\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u0010H\u0007J$\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00140'H\u0002J$\u0010)\u001a\u00020\u00142\u0006\u0010$\u001a\u00020%2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020\u00140'H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006*"}, d2={"Lio/javalin/websocket/WsHandlerController;", "", "matcher", "Lio/javalin/websocket/WsPathMatcher;", "exceptionMapper", "Lio/javalin/websocket/WsExceptionMapper;", "wsLogger", "Lio/javalin/websocket/WsHandler;", "(Lio/javalin/websocket/WsPathMatcher;Lio/javalin/websocket/WsExceptionMapper;Lio/javalin/websocket/WsHandler;)V", "getExceptionMapper", "()Lio/javalin/websocket/WsExceptionMapper;", "getMatcher", "()Lio/javalin/websocket/WsPathMatcher;", "sessionIds", "Ljava/util/concurrent/ConcurrentHashMap;", "Lorg/eclipse/jetty/websocket/api/Session;", "", "getWsLogger", "()Lio/javalin/websocket/WsHandler;", "onClose", "", "session", "statusCode", "", "reason", "onConnect", "onError", "throwable", "", "onMessage", "buffer", "", "offset", "length", "message", "tryAfterHandlers", "ctx", "Lio/javalin/websocket/WsContext;", "handle", "Lkotlin/Function1;", "Lio/javalin/websocket/WsEntry;", "tryBeforeAndEndpointHandlers", "javalin"})
public final class WsHandlerController {
    private final ConcurrentHashMap<Session, String> sessionIds;
    @NotNull
    private final WsPathMatcher matcher;
    @NotNull
    private final WsExceptionMapper exceptionMapper;
    @Nullable
    private final WsHandler wsLogger;

    @OnWebSocketConnect
    public final void onConnect(@NotNull Session session) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            Map map = this.sessionIds;
            String string = UUID.randomUUID().toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"UUID.randomUUID().toString()");
            map.put(session, string);
            String string2 = this.sessionIds.get(session);
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"sessionIds[session]!!");
            WsConnectContext ctx = new WsConnectContext(string2, session);
            this.tryBeforeAndEndpointHandlers(ctx, (Function1<? super WsEntry, Unit>)((Function1)new Function1<WsEntry, Unit>(ctx){
                final /* synthetic */ WsConnectContext $ctx;

                public final void invoke(@NotNull WsEntry it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        WsConnectHandler wsConnectHandler = it.getHandler().wsConnectHandler;
                        if (wsConnectHandler == null) break block0;
                        wsConnectHandler.handleConnect(this.$ctx);
                    }
                }
                {
                    this.$ctx = wsConnectContext;
                    super(1);
                }
            }));
            this.tryAfterHandlers(ctx, (Function1<? super WsEntry, Unit>)((Function1)new Function1<WsEntry, Unit>(ctx){
                final /* synthetic */ WsConnectContext $ctx;

                public final void invoke(@NotNull WsEntry it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        WsConnectHandler wsConnectHandler = it.getHandler().wsConnectHandler;
                        if (wsConnectHandler == null) break block0;
                        wsConnectHandler.handleConnect(this.$ctx);
                    }
                }
                {
                    this.$ctx = wsConnectContext;
                    super(1);
                }
            }));
            Object object = this.wsLogger;
            if (object == null || (object = ((WsHandler)object).wsConnectHandler) == null) break block1;
            object.handleConnect(ctx);
        }
    }

    @OnWebSocketMessage
    public final void onMessage(@NotNull Session session, @NotNull String message) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
            String string = this.sessionIds.get(session);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sessionIds[session]!!");
            WsMessageContext ctx = new WsMessageContext(string, session, message);
            this.tryBeforeAndEndpointHandlers(ctx, (Function1<? super WsEntry, Unit>)((Function1)new Function1<WsEntry, Unit>(ctx){
                final /* synthetic */ WsMessageContext $ctx;

                public final void invoke(@NotNull WsEntry it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        WsMessageHandler wsMessageHandler = it.getHandler().wsMessageHandler;
                        if (wsMessageHandler == null) break block0;
                        wsMessageHandler.handleMessage(this.$ctx);
                    }
                }
                {
                    this.$ctx = wsMessageContext;
                    super(1);
                }
            }));
            this.tryAfterHandlers(ctx, (Function1<? super WsEntry, Unit>)((Function1)new Function1<WsEntry, Unit>(ctx){
                final /* synthetic */ WsMessageContext $ctx;

                public final void invoke(@NotNull WsEntry it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        WsMessageHandler wsMessageHandler = it.getHandler().wsMessageHandler;
                        if (wsMessageHandler == null) break block0;
                        wsMessageHandler.handleMessage(this.$ctx);
                    }
                }
                {
                    this.$ctx = wsMessageContext;
                    super(1);
                }
            }));
            Object object = this.wsLogger;
            if (object == null || (object = ((WsHandler)object).wsMessageHandler) == null) break block1;
            object.handleMessage(ctx);
        }
    }

    @OnWebSocketMessage
    public final void onMessage(@NotNull Session session, @NotNull byte[] buffer, int offset, int length) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
            String string = this.sessionIds.get(session);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sessionIds[session]!!");
            WsBinaryMessageContext ctx = new WsBinaryMessageContext(string, session, buffer, offset, length);
            this.tryBeforeAndEndpointHandlers(ctx, (Function1<? super WsEntry, Unit>)((Function1)new Function1<WsEntry, Unit>(ctx){
                final /* synthetic */ WsBinaryMessageContext $ctx;

                public final void invoke(@NotNull WsEntry it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        WsBinaryMessageHandler wsBinaryMessageHandler = it.getHandler().wsBinaryMessageHandler;
                        if (wsBinaryMessageHandler == null) break block0;
                        wsBinaryMessageHandler.handleBinaryMessage(this.$ctx);
                    }
                }
                {
                    this.$ctx = wsBinaryMessageContext;
                    super(1);
                }
            }));
            this.tryAfterHandlers(ctx, (Function1<? super WsEntry, Unit>)((Function1)new Function1<WsEntry, Unit>(ctx){
                final /* synthetic */ WsBinaryMessageContext $ctx;

                public final void invoke(@NotNull WsEntry it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        WsBinaryMessageHandler wsBinaryMessageHandler = it.getHandler().wsBinaryMessageHandler;
                        if (wsBinaryMessageHandler == null) break block0;
                        wsBinaryMessageHandler.handleBinaryMessage(this.$ctx);
                    }
                }
                {
                    this.$ctx = wsBinaryMessageContext;
                    super(1);
                }
            }));
            Object object = this.wsLogger;
            if (object == null || (object = ((WsHandler)object).wsBinaryMessageHandler) == null) break block1;
            object.handleBinaryMessage(ctx);
        }
    }

    @OnWebSocketClose
    public final void onClose(@NotNull Session session, int statusCode, @Nullable String reason) {
        Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
        String string = this.sessionIds.get(session);
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sessionIds[session]!!");
        WsCloseContext ctx = new WsCloseContext(string, session, statusCode, reason);
        this.tryBeforeAndEndpointHandlers(ctx, (Function1<? super WsEntry, Unit>)((Function1)new Function1<WsEntry, Unit>(ctx){
            final /* synthetic */ WsCloseContext $ctx;

            public final void invoke(@NotNull WsEntry it) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    WsCloseHandler wsCloseHandler = it.getHandler().wsCloseHandler;
                    if (wsCloseHandler == null) break block0;
                    wsCloseHandler.handleClose(this.$ctx);
                }
            }
            {
                this.$ctx = wsCloseContext;
                super(1);
            }
        }));
        this.tryAfterHandlers(ctx, (Function1<? super WsEntry, Unit>)((Function1)new Function1<WsEntry, Unit>(ctx){
            final /* synthetic */ WsCloseContext $ctx;

            public final void invoke(@NotNull WsEntry it) {
                block0: {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    WsCloseHandler wsCloseHandler = it.getHandler().wsCloseHandler;
                    if (wsCloseHandler == null) break block0;
                    wsCloseHandler.handleClose(this.$ctx);
                }
            }
            {
                this.$ctx = wsCloseContext;
                super(1);
            }
        }));
        Object object = this.wsLogger;
        if (object != null && (object = ((WsHandler)object).wsCloseHandler) != null) {
            object.handleClose(ctx);
        }
        this.sessionIds.remove(session);
    }

    @OnWebSocketError
    public final void onError(@NotNull Session session, @Nullable Throwable throwable) {
        block1: {
            Intrinsics.checkParameterIsNotNull((Object)session, (String)"session");
            String string = this.sessionIds.get(session);
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sessionIds[session]!!");
            WsErrorContext ctx = new WsErrorContext(string, session, throwable);
            this.tryBeforeAndEndpointHandlers(ctx, (Function1<? super WsEntry, Unit>)((Function1)new Function1<WsEntry, Unit>(ctx){
                final /* synthetic */ WsErrorContext $ctx;

                public final void invoke(@NotNull WsEntry it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        WsErrorHandler wsErrorHandler = it.getHandler().wsErrorHandler;
                        if (wsErrorHandler == null) break block0;
                        wsErrorHandler.handleError(this.$ctx);
                    }
                }
                {
                    this.$ctx = wsErrorContext;
                    super(1);
                }
            }));
            this.tryAfterHandlers(ctx, (Function1<? super WsEntry, Unit>)((Function1)new Function1<WsEntry, Unit>(ctx){
                final /* synthetic */ WsErrorContext $ctx;

                public final void invoke(@NotNull WsEntry it) {
                    block0: {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        WsErrorHandler wsErrorHandler = it.getHandler().wsErrorHandler;
                        if (wsErrorHandler == null) break block0;
                        wsErrorHandler.handleError(this.$ctx);
                    }
                }
                {
                    this.$ctx = wsErrorContext;
                    super(1);
                }
            }));
            Object object = this.wsLogger;
            if (object == null || (object = ((WsHandler)object).wsErrorHandler) == null) break block1;
            object.handleError(ctx);
        }
    }

    private final void tryBeforeAndEndpointHandlers(WsContext ctx, Function1<? super WsEntry, Unit> handle2) {
        String requestUri = WsHandlerControllerKt.access$uriNoContextPath(ctx.session);
        try {
            Object $this$forEach$iv = this.matcher.findBeforeHandlerEntries(requestUri);
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv = iterator.next();
                WsEntry it = (WsEntry)element$iv;
                boolean bl = false;
                handle2.invoke((Object)it);
            }
            WsEntry wsEntry = this.matcher.findEndpointHandlerEntry(requestUri);
            if (wsEntry == null) {
                Intrinsics.throwNpe();
            }
            $this$forEach$iv = wsEntry;
            boolean bl = false;
            boolean bl2 = false;
            Object it = $this$forEach$iv;
            boolean bl3 = false;
            handle2.invoke(it);
        }
        catch (Exception e) {
            this.exceptionMapper.handle(e, ctx);
        }
    }

    private final void tryAfterHandlers(WsContext ctx, Function1<? super WsEntry, Unit> handle2) {
        String requestUri = WsHandlerControllerKt.access$uriNoContextPath(ctx.session);
        try {
            Iterable $this$forEach$iv = this.matcher.findAfterHandlerEntries(requestUri);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                WsEntry it = (WsEntry)element$iv;
                boolean bl = false;
                handle2.invoke((Object)it);
            }
        }
        catch (Exception e) {
            this.exceptionMapper.handle(e, ctx);
        }
    }

    @NotNull
    public final WsPathMatcher getMatcher() {
        return this.matcher;
    }

    @NotNull
    public final WsExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    @Nullable
    public final WsHandler getWsLogger() {
        return this.wsLogger;
    }

    public WsHandlerController(@NotNull WsPathMatcher matcher, @NotNull WsExceptionMapper exceptionMapper, @Nullable WsHandler wsLogger) {
        Intrinsics.checkParameterIsNotNull((Object)matcher, (String)"matcher");
        Intrinsics.checkParameterIsNotNull((Object)exceptionMapper, (String)"exceptionMapper");
        this.matcher = matcher;
        this.exceptionMapper = exceptionMapper;
        this.wsLogger = wsLogger;
        this.sessionIds = new ConcurrentHashMap();
    }
}

