/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.http;

import io.javalin.Javalin;
import io.javalin.core.JavalinConfig;
import io.javalin.core.security.Role;
import io.javalin.core.util.CorsPlugin;
import io.javalin.core.util.LogUtil;
import io.javalin.core.util.Util;
import io.javalin.http.Context;
import io.javalin.http.ErrorMapper;
import io.javalin.http.ExceptionMapper;
import io.javalin.http.Handler;
import io.javalin.http.HandlerEntry;
import io.javalin.http.HandlerType;
import io.javalin.http.JavalinResponseWrapper;
import io.javalin.http.JavalinServlet;
import io.javalin.http.MethodNotAllowedResponse;
import io.javalin.http.NotFoundResponse;
import io.javalin.http.PathMatcher;
import io.javalin.http.RequestLogger;
import io.javalin.http.RequestWrapper;
import io.javalin.http.ResponseWrapperContext;
import io.javalin.http.staticfiles.ResourceHandler;
import io.javalin.http.util.ContextUtil;
import io.javalin.http.util.MethodNotAllowedUtil;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.servlet.AsyncContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001cJ\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u0018H\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u0018\u0010\"\u001a\u00020\u00142\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006'"}, d2={"Lio/javalin/http/JavalinServlet;", "Ljavax/servlet/http/HttpServlet;", "config", "Lio/javalin/core/JavalinConfig;", "(Lio/javalin/core/JavalinConfig;)V", "getConfig", "()Lio/javalin/core/JavalinConfig;", "errorMapper", "Lio/javalin/http/ErrorMapper;", "getErrorMapper", "()Lio/javalin/http/ErrorMapper;", "exceptionMapper", "Lio/javalin/http/ExceptionMapper;", "getExceptionMapper", "()Lio/javalin/http/ExceptionMapper;", "matcher", "Lio/javalin/http/PathMatcher;", "getMatcher", "()Lio/javalin/http/PathMatcher;", "addHandler", "", "handlerType", "Lio/javalin/http/HandlerType;", "path", "", "handler", "Lio/javalin/http/Handler;", "roles", "", "Lio/javalin/core/security/Role;", "hasGetHandlerMapped", "", "requestUri", "isCorsEnabled", "service", "rawReq", "Ljavax/servlet/http/HttpServletRequest;", "rawRes", "Ljavax/servlet/http/HttpServletResponse;", "javalin"})
public final class JavalinServlet
extends HttpServlet {
    @NotNull
    private final PathMatcher matcher;
    @NotNull
    private final ExceptionMapper exceptionMapper;
    @NotNull
    private final ErrorMapper errorMapper;
    @NotNull
    private final JavalinConfig config;

    @NotNull
    public final PathMatcher getMatcher() {
        return this.matcher;
    }

    @NotNull
    public final ExceptionMapper getExceptionMapper() {
        return this.exceptionMapper;
    }

    @NotNull
    public final ErrorMapper getErrorMapper() {
        return this.errorMapper;
    }

    protected void service(@NotNull HttpServletRequest rawReq, @NotNull HttpServletResponse rawRes) {
        block5: {
            Intrinsics.checkParameterIsNotNull((Object)rawReq, (String)"rawReq");
            Intrinsics.checkParameterIsNotNull((Object)rawRes, (String)"rawRes");
            try {
                RequestWrapper wrappedReq = new RequestWrapper(rawReq, this.config);
                HandlerType type2 = HandlerType.Companion.fromServletRequest((HttpServletRequest)wrappedReq);
                ResponseWrapperContext rwc = new ResponseWrapperContext(rawReq, this.config);
                String string = wrappedReq.getRequestURI();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"wrappedReq.requestURI");
                String string2 = wrappedReq.getContextPath();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"wrappedReq.contextPath");
                String requestUri = StringsKt.removePrefix((String)string, (CharSequence)string2);
                HttpServletRequest httpServletRequest = (HttpServletRequest)wrappedReq;
                Map<Class<?>, Object> map = this.config.inner.appAttributes;
                Intrinsics.checkExpressionValueIsNotNull(map, (String)"config.inner.appAttributes");
                Context ctx = new Context(httpServletRequest, rawRes, map);
                Function1<Function0<? extends Unit>, Unit> $fun$tryWithExceptionMapper$1 = new Function1<Function0<? extends Unit>, Unit>(this, ctx){
                    final /* synthetic */ JavalinServlet this$0;
                    final /* synthetic */ Context $ctx;

                    /*
                     * WARNING - void declaration
                     */
                    public final void invoke(@NotNull Function0<Unit> func) {
                        Intrinsics.checkParameterIsNotNull(func, (String)"func");
                        ExceptionMapper exceptionMapper = this.this$0.getExceptionMapper();
                        Context ctx$iv = this.$ctx;
                        boolean $i$f$catchException$javalin = false;
                        try {
                            func.invoke();
                        }
                        catch (Exception e$iv) {
                            void this_$iv;
                            this_$iv.handle$javalin(e$iv, ctx$iv);
                        }
                    }
                    {
                        this.this$0 = javalinServlet;
                        this.$ctx = context;
                        super(1);
                    }
                };
                Function0<Unit> $fun$tryBeforeAndEndpointHandlers$2 = new Function0<Unit>(this, $fun$tryWithExceptionMapper$1, requestUri, ctx, type2, wrappedReq, rawRes, rwc){
                    final /* synthetic */ JavalinServlet this$0;
                    final /* synthetic */ service.1 $tryWithExceptionMapper$1;
                    final /* synthetic */ String $requestUri;
                    final /* synthetic */ Context $ctx;
                    final /* synthetic */ HandlerType $type;
                    final /* synthetic */ RequestWrapper $wrappedReq;
                    final /* synthetic */ HttpServletResponse $rawRes;
                    final /* synthetic */ ResponseWrapperContext $rwc;

                    public final void invoke() {
                        this.$tryWithExceptionMapper$1.invoke((Function0<Unit>)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ service.2 this$0;

                            public final void invoke() {
                                Object $this$forEach$iv = this.this$0.this$0.getMatcher().findEntries(HandlerType.BEFORE, this.this$0.$requestUri);
                                boolean $i$f$forEach = false;
                                Iterator<T> iterator = $this$forEach$iv.iterator();
                                while (iterator.hasNext()) {
                                    T element$iv = iterator.next();
                                    HandlerEntry entry = (HandlerEntry)element$iv;
                                    boolean bl = false;
                                    entry.getHandler().handle(ContextUtil.INSTANCE.update(this.this$0.$ctx, entry, this.this$0.$requestUri));
                                }
                                HandlerEntry handlerEntry = (HandlerEntry)CollectionsKt.firstOrNull(this.this$0.this$0.getMatcher().findEntries(this.this$0.$type, this.this$0.$requestUri));
                                if (handlerEntry != null) {
                                    $this$forEach$iv = handlerEntry;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    Object entry = $this$forEach$iv;
                                    boolean bl3 = false;
                                    ((HandlerEntry)entry).getHandler().handle(ContextUtil.INSTANCE.update(this.this$0.$ctx, (HandlerEntry)entry, this.this$0.$requestUri));
                                    return;
                                }
                                if (this.this$0.$type == HandlerType.HEAD && JavalinServlet.access$hasGetHandlerMapped(this.this$0.this$0, this.this$0.$requestUri)) {
                                    return;
                                }
                                if (this.this$0.$type == HandlerType.HEAD || this.this$0.$type == HandlerType.GET) {
                                    ResourceHandler resourceHandler = this.this$0.this$0.getConfig().inner.resourceHandler;
                                    if (resourceHandler != null) {
                                        if (resourceHandler.handle((HttpServletRequest)this.this$0.$wrappedReq, (HttpServletResponse)new JavalinResponseWrapper(this.this$0.$rawRes, this.this$0.$rwc))) {
                                            return;
                                        }
                                    }
                                    if (this.this$0.this$0.getConfig().inner.singlePageHandler.handle(this.this$0.$ctx)) {
                                        return;
                                    }
                                }
                                if (this.this$0.$type == HandlerType.OPTIONS && JavalinServlet.access$isCorsEnabled(this.this$0.this$0, this.this$0.this$0.getConfig())) {
                                    return;
                                }
                                if (this.this$0.$ctx.getHandlerType$javalin() == HandlerType.BEFORE) {
                                    this.this$0.$ctx.setEndpointHandlerPath$javalin("No handler matched request path/method (404/405)");
                                }
                                List<HandlerType> availableHandlerTypes = MethodNotAllowedUtil.INSTANCE.findAvailableHttpHandlerTypes(this.this$0.this$0.getMatcher(), this.this$0.$requestUri);
                                if (this.this$0.this$0.getConfig().prefer405over404) {
                                    Collection collection = availableHandlerTypes;
                                    boolean bl = false;
                                    if (!collection.isEmpty()) {
                                        throw (Throwable)new MethodNotAllowedResponse(null, MethodNotAllowedUtil.INSTANCE.getAvailableHandlerTypes(this.this$0.$ctx, availableHandlerTypes), 1, null);
                                    }
                                }
                                throw (Throwable)new NotFoundResponse(null, 1, null);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }));
                    }
                    {
                        this.this$0 = javalinServlet;
                        this.$tryWithExceptionMapper$1 = var2_2;
                        this.$requestUri = string;
                        this.$ctx = context;
                        this.$type = handlerType;
                        this.$wrappedReq = requestWrapper;
                        this.$rawRes = httpServletResponse;
                        this.$rwc = responseWrapperContext;
                        super(0);
                    }
                };
                Function0<Unit> $fun$tryErrorHandlers$3 = new Function0<Unit>(this, $fun$tryWithExceptionMapper$1, ctx){
                    final /* synthetic */ JavalinServlet this$0;
                    final /* synthetic */ service.1 $tryWithExceptionMapper$1;
                    final /* synthetic */ Context $ctx;

                    public final void invoke() {
                        this.$tryWithExceptionMapper$1.invoke((Function0<Unit>)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ service.3 this$0;

                            public final void invoke() {
                                this.this$0.this$0.getErrorMapper().handle(this.this$0.$ctx.status(), this.this$0.$ctx);
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }));
                    }
                    {
                        this.this$0 = javalinServlet;
                        this.$tryWithExceptionMapper$1 = var2_2;
                        this.$ctx = context;
                        super(0);
                    }
                };
                Function0<Unit> $fun$tryAfterHandlers$4 = new Function0<Unit>(this, $fun$tryWithExceptionMapper$1, requestUri, ctx){
                    final /* synthetic */ JavalinServlet this$0;
                    final /* synthetic */ service.1 $tryWithExceptionMapper$1;
                    final /* synthetic */ String $requestUri;
                    final /* synthetic */ Context $ctx;

                    public final void invoke() {
                        this.$tryWithExceptionMapper$1.invoke((Function0<Unit>)((Function0)new Function0<Unit>(this){
                            final /* synthetic */ service.4 this$0;

                            public final void invoke() {
                                Iterable $this$forEach$iv = this.this$0.this$0.getMatcher().findEntries(HandlerType.AFTER, this.this$0.$requestUri);
                                boolean $i$f$forEach = false;
                                for (T element$iv : $this$forEach$iv) {
                                    HandlerEntry entry = (HandlerEntry)element$iv;
                                    boolean bl = false;
                                    entry.getHandler().handle(ContextUtil.INSTANCE.update(this.this$0.$ctx, entry, this.this$0.$requestUri));
                                }
                            }
                            {
                                this.this$0 = var1_1;
                                super(0);
                            }
                        }));
                    }
                    {
                        this.this$0 = javalinServlet;
                        this.$tryWithExceptionMapper$1 = var2_2;
                        this.$requestUri = string;
                        this.$ctx = context;
                        super(0);
                    }
                };
                LogUtil.INSTANCE.setup(ctx, this.matcher);
                ctx.header("Server", "Javalin");
                String string3 = this.config.defaultContentType;
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"config.defaultContentType");
                ctx.contentType(string3);
                $fun$tryBeforeAndEndpointHandlers$2.invoke();
                if (ctx.resultFuture() == null) {
                    $fun$tryErrorHandlers$3.invoke();
                    $fun$tryAfterHandlers$4.invoke();
                    new JavalinResponseWrapper(rawRes, rwc).write(ctx.resultStream());
                    RequestLogger requestLogger = this.config.inner.requestLogger;
                    if (requestLogger == null) break block5;
                    requestLogger.handle(ctx, Float.valueOf(LogUtil.INSTANCE.executionTimeMs(ctx)));
                    break block5;
                }
                AsyncContext asyncContext = wrappedReq.startAsync();
                boolean bl = false;
                boolean bl2 = false;
                AsyncContext $this$apply = asyncContext;
                boolean bl3 = false;
                Long l = this.config.asyncRequestTimeout;
                Intrinsics.checkExpressionValueIsNotNull((Object)l, (String)"config.asyncRequestTimeout");
                $this$apply.setTimeout(l.longValue());
                AsyncContext asyncContext2 = asyncContext;
                CompletableFuture<?> completableFuture = ctx.resultFuture();
                if (completableFuture == null) {
                    Intrinsics.throwNpe();
                }
                ((CompletableFuture)((CompletableFuture)completableFuture.exceptionally(new Function(this, ctx){
                    final /* synthetic */ JavalinServlet this$0;
                    final /* synthetic */ Context $ctx;

                    @Nullable
                    public final Void apply(Throwable throwable) {
                        if (throwable instanceof CompletionException && throwable.getCause() instanceof Exception) {
                            Throwable throwable2 = throwable.getCause();
                            if (throwable2 == null) {
                                throw new TypeCastException("null cannot be cast to non-null type kotlin.Exception /* = java.lang.Exception */");
                            }
                            this.this$0.getExceptionMapper().handle$javalin((Exception)throwable2, this.$ctx);
                        } else if (throwable instanceof Exception) {
                            this.this$0.getExceptionMapper().handle$javalin((Exception)throwable, this.$ctx);
                        }
                        return null;
                    }
                    {
                        this.this$0 = javalinServlet;
                        this.$ctx = context;
                    }
                })).thenAccept(new Consumer<Object>(this, ctx, $fun$tryErrorHandlers$3, $fun$tryAfterHandlers$4, asyncContext2, rwc){
                    final /* synthetic */ JavalinServlet this$0;
                    final /* synthetic */ Context $ctx;
                    final /* synthetic */ service.3 $tryErrorHandlers$3;
                    final /* synthetic */ service.4 $tryAfterHandlers$4;
                    final /* synthetic */ AsyncContext $asyncContext;
                    final /* synthetic */ ResponseWrapperContext $rwc;

                    public final void accept(Object it) {
                        Object object = it;
                        if (object instanceof InputStream) {
                            this.$ctx.result((InputStream)it);
                        } else if (object instanceof String) {
                            this.$ctx.result((String)it);
                        }
                        this.$tryErrorHandlers$3.invoke();
                        this.$tryAfterHandlers$4.invoke();
                        AsyncContext asyncContext = this.$asyncContext;
                        Intrinsics.checkExpressionValueIsNotNull((Object)asyncContext, (String)"asyncContext");
                        ServletResponse servletResponse = asyncContext.getResponse();
                        if (servletResponse == null) {
                            throw new TypeCastException("null cannot be cast to non-null type javax.servlet.http.HttpServletResponse");
                        }
                        HttpServletResponse asyncRes = (HttpServletResponse)servletResponse;
                        new JavalinResponseWrapper(asyncRes, this.$rwc).write(this.$ctx.resultStream());
                        RequestLogger requestLogger = this.this$0.getConfig().inner.requestLogger;
                        if (requestLogger != null) {
                            requestLogger.handle(this.$ctx, Float.valueOf(LogUtil.INSTANCE.executionTimeMs(this.$ctx)));
                        }
                        this.$asyncContext.complete();
                    }
                    {
                        this.this$0 = javalinServlet;
                        this.$ctx = context;
                        this.$tryErrorHandlers$3 = var3_3;
                        this.$tryAfterHandlers$4 = var4_4;
                        this.$asyncContext = asyncContext;
                        this.$rwc = responseWrapperContext;
                    }
                })).exceptionally(new Function<Throwable, Void>(rawRes, asyncContext2){
                    final /* synthetic */ HttpServletResponse $rawRes;
                    final /* synthetic */ AsyncContext $asyncContext;

                    @Nullable
                    public final Void apply(Throwable t) {
                        Throwable throwable = t;
                        Intrinsics.checkExpressionValueIsNotNull((Object)throwable, (String)"t");
                        if (!Util.INSTANCE.isClientAbortException(throwable)) {
                            this.$rawRes.setStatus(500);
                            Logger logger = Javalin.log;
                            if (logger != null) {
                                logger.error("Exception occurred while servicing http-request", t);
                            }
                        }
                        this.$asyncContext.complete();
                        return null;
                    }
                    {
                        this.$rawRes = httpServletResponse;
                        this.$asyncContext = asyncContext;
                    }
                });
            }
            catch (Throwable t) {
                if (Util.INSTANCE.isClientAbortException(t)) break block5;
                rawRes.setStatus(500);
                Logger logger = Javalin.log;
                if (logger != null) {
                    logger.error("Exception occurred while servicing http-request", t);
                }
            }
        }
    }

    private final boolean hasGetHandlerMapped(String requestUri) {
        Collection collection = this.matcher.findEntries(HandlerType.GET, requestUri);
        boolean bl = false;
        return !collection.isEmpty();
    }

    public final void addHandler(@NotNull HandlerType handlerType, @NotNull String path, @NotNull Handler handler, @NotNull Set<? extends Role> roles) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)handlerType), (String)"handlerType");
        Intrinsics.checkParameterIsNotNull((Object)path, (String)"path");
        Intrinsics.checkParameterIsNotNull((Object)handler, (String)"handler");
        Intrinsics.checkParameterIsNotNull(roles, (String)"roles");
        Handler protectedHandler2 = handlerType.isHttpMethod() ? (Handler)new Handler(this, handler, roles){
            final /* synthetic */ JavalinServlet this$0;
            final /* synthetic */ Handler $handler;
            final /* synthetic */ Set $roles;

            public final void handle(@NotNull Context ctx) {
                Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
                this.this$0.getConfig().inner.accessManager.manage(this.$handler, ctx, this.$roles);
            }
            {
                this.this$0 = javalinServlet;
                this.$handler = handler;
                this.$roles = set;
            }
        } : handler;
        this.matcher.add(new HandlerEntry(handlerType, path, this.config.ignoreTrailingSlashes, protectedHandler2, handler));
    }

    private final boolean isCorsEnabled(JavalinConfig config) {
        return config.inner.plugins.get(CorsPlugin.class) != null;
    }

    @NotNull
    public final JavalinConfig getConfig() {
        return this.config;
    }

    public JavalinServlet(@NotNull JavalinConfig config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.matcher = new PathMatcher();
        this.exceptionMapper = new ExceptionMapper();
        this.errorMapper = new ErrorMapper();
    }

    public static final /* synthetic */ boolean access$hasGetHandlerMapped(JavalinServlet $this, String requestUri) {
        return $this.hasGetHandlerMapped(requestUri);
    }

    public static final /* synthetic */ boolean access$isCorsEnabled(JavalinServlet $this, JavalinConfig config) {
        return $this.isCorsEnabled(config);
    }
}

