/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.core.util;

import io.javalin.Javalin;
import io.javalin.core.event.EventListener;
import io.javalin.core.event.HandlerMetaInfo;
import io.javalin.core.event.WsHandlerMetaInfo;
import io.javalin.core.util.RouteOverviewUtil;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import io.javalin.plugin.openapi.annotations.OpenApi;
import io.javalin.plugin.openapi.annotations.OpenApiContent;
import io.javalin.plugin.openapi.annotations.OpenApiResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000b\u00a8\u0006\u0013"}, d2={"Lio/javalin/core/util/RouteOverviewRenderer;", "Lio/javalin/http/Handler;", "app", "Lio/javalin/Javalin;", "(Lio/javalin/Javalin;)V", "getApp", "()Lio/javalin/Javalin;", "handlerMetaInfoList", "", "Lio/javalin/core/event/HandlerMetaInfo;", "getHandlerMetaInfoList", "()Ljava/util/List;", "wsHandlerMetaInfoList", "Lio/javalin/core/event/WsHandlerMetaInfo;", "getWsHandlerMetaInfoList", "handle", "", "ctx", "Lio/javalin/http/Context;", "javalin"})
public final class RouteOverviewRenderer
implements Handler {
    @NotNull
    private final List<HandlerMetaInfo> handlerMetaInfoList;
    @NotNull
    private final List<WsHandlerMetaInfo> wsHandlerMetaInfoList;
    @NotNull
    private final Javalin app;

    @NotNull
    public final List<HandlerMetaInfo> getHandlerMetaInfoList() {
        return this.handlerMetaInfoList;
    }

    @NotNull
    public final List<WsHandlerMetaInfo> getWsHandlerMetaInfoList() {
        return this.wsHandlerMetaInfoList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    @OpenApi(summary="Get an overview of all the routes in the application", responses={@OpenApiResponse(status="200", content={@OpenApiContent(type="text/html")})})
    public void handle(@NotNull Context ctx) {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        String string = ctx.header("Accept");
        if (string != null) {
            String string2 = string;
            boolean bl = false;
            String string3 = string2;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase();
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).toLowerCase()");
            string = string4;
            if (string4 != null) {
                if (StringsKt.contains$default((CharSequence)string, (CharSequence)"application/json", (boolean)false, (int)2, null)) {
                    ctx.header("Content-Type", "application/json");
                    ctx.result(RouteOverviewUtil.createJsonOverview(this.handlerMetaInfoList, this.wsHandlerMetaInfoList));
                    return;
                }
            }
        }
        ctx.html(RouteOverviewUtil.createHtmlOverview(this.handlerMetaInfoList, this.wsHandlerMetaInfoList));
    }

    @NotNull
    public final Javalin getApp() {
        return this.app;
    }

    public RouteOverviewRenderer(@NotNull Javalin app) {
        List list;
        Intrinsics.checkParameterIsNotNull((Object)app, (String)"app");
        this.app = app;
        RouteOverviewRenderer routeOverviewRenderer = this;
        boolean bl = false;
        routeOverviewRenderer.handlerMetaInfoList = list = (List)new ArrayList();
        routeOverviewRenderer = this;
        bl = false;
        routeOverviewRenderer.wsHandlerMetaInfoList = list = (List)new ArrayList();
        this.app.events(new Consumer<EventListener>(){

            @Override
            public final void accept(EventListener it) {
                it.handlerAdded(new Consumer<HandlerMetaInfo>(){

                    @Override
                    public final void accept(HandlerMetaInfo handlerInfo) {
                        List<HandlerMetaInfo> list = this.getHandlerMetaInfoList();
                        HandlerMetaInfo handlerMetaInfo = handlerInfo;
                        Intrinsics.checkExpressionValueIsNotNull((Object)handlerMetaInfo, (String)"handlerInfo");
                        list.add(handlerMetaInfo);
                    }
                });
            }
        });
        this.app.events(new Consumer<EventListener>(){

            @Override
            public final void accept(EventListener it) {
                it.wsHandlerAdded(new Consumer<WsHandlerMetaInfo>(){

                    @Override
                    public final void accept(WsHandlerMetaInfo handlerInfo) {
                        List<WsHandlerMetaInfo> list = this.getWsHandlerMetaInfoList();
                        WsHandlerMetaInfo wsHandlerMetaInfo = handlerInfo;
                        Intrinsics.checkExpressionValueIsNotNull((Object)wsHandlerMetaInfo, (String)"handlerInfo");
                        list.add(wsHandlerMetaInfo);
                    }
                });
            }
        });
    }
}

