/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter.set;

import io.holunda.camunda.bpm.data.adapter.set.AbstractSetReadWriteAdapter;
import java.util.Optional;
import java.util.Set;
import org.camunda.bpm.engine.RuntimeService;

public class SetReadWriteAdapterRuntimeService<T>
extends AbstractSetReadWriteAdapter<T> {
    private final RuntimeService runtimeService;
    private final String executionId;

    public SetReadWriteAdapterRuntimeService(RuntimeService runtimeService, String executionId, String variableName, Class<T> memberClazz) {
        super(variableName, memberClazz);
        this.runtimeService = runtimeService;
        this.executionId = executionId;
    }

    @Override
    public Optional<Set<T>> getOptional() {
        return Optional.ofNullable(this.getOrNull(this.runtimeService.getVariable(this.executionId, this.variableName)));
    }

    @Override
    public void set(Set<T> value, boolean isTransient) {
        this.runtimeService.setVariable(this.executionId, this.variableName, (Object)this.getTypedValue(value, isTransient));
    }

    @Override
    public Optional<Set<T>> getLocalOptional() {
        return Optional.ofNullable(this.getOrNull(this.runtimeService.getVariableLocal(this.executionId, this.variableName)));
    }

    @Override
    public void setLocal(Set<T> value, boolean isTransient) {
        this.runtimeService.setVariableLocal(this.executionId, this.variableName, (Object)this.getTypedValue(value, isTransient));
    }

    @Override
    public void remove() {
        this.runtimeService.removeVariable(this.executionId, this.variableName);
    }

    @Override
    public void removeLocal() {
        this.runtimeService.removeVariableLocal(this.executionId, this.variableName);
    }
}

