/*
 * Decompiled with CFR 0.152.
 */
package io.holunda.camunda.bpm.data.adapter.set;

import io.holunda.camunda.bpm.data.adapter.AbstractReadWriteAdapter;
import io.holunda.camunda.bpm.data.adapter.ValueWrapperUtil;
import io.holunda.camunda.bpm.data.adapter.WrongVariableTypeException;
import java.util.Collections;
import java.util.Set;
import org.camunda.bpm.engine.variable.value.TypedValue;

public abstract class AbstractSetReadWriteAdapter<T>
extends AbstractReadWriteAdapter<Set<T>> {
    protected final Class<T> memberClazz;

    public AbstractSetReadWriteAdapter(String variableName, Class<T> memberClazz) {
        super(variableName);
        this.memberClazz = memberClazz;
    }

    protected Set<T> getOrNull(Object value) {
        if (value == null) {
            return null;
        }
        if (Set.class.isAssignableFrom(value.getClass())) {
            Set valueAsList = (Set)value;
            if (valueAsList.isEmpty()) {
                return Collections.emptySet();
            }
            if (this.memberClazz.isAssignableFrom(valueAsList.iterator().next().getClass())) {
                return valueAsList;
            }
            throw new WrongVariableTypeException("Error reading " + this.variableName + ": Wrong set type detected, expected " + this.memberClazz.getName() + ", but was not found in " + valueAsList);
        }
        throw new WrongVariableTypeException("Error reading " + this.variableName + ": Couldn't read value of type Set from " + value);
    }

    @Override
    public TypedValue getTypedValue(Object value, boolean isTransient) {
        return ValueWrapperUtil.getTypedValue(Set.class, value, isTransient);
    }
}

